% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaSPUtils.R
\name{gp.model.adequacy}
\alias{gp.model.adequacy}
\title{Model assessment based on Deviance information criterion (DIC), logarithmic pointwise predictive density (lppd), and
logarithmic joint predictive density (ljpd).}
\usage{
gp.model.adequacy(
  obj,
  testing.input,
  testing.output,
  pointwise = TRUE,
  joint = TRUE
)
}
\arguments{
\item{obj}{a \code{\link{gp}} object.}

\item{testing.input}{a matrix of testing inputs}

\item{testing.output}{a vector of testing outputs}

\item{pointwise}{a logical value with default value \code{TRUE}. If it is
\code{TRUE}, \strong{lppd} is calculated.}

\item{joint}{a logical value with default value \code{TRUE}. If it is
\code{TRUE}, \strong{ljpd} is calculated.}
}
\value{
a list containingg \strong{pD}, \strong{DIC}, \strong{lppd}, \strong{ljpd}.
}
\description{
This function computes effective number of parameters (pD), deviance information criterion (DIC), logarithmic pointwise predictive density (lppd), and
logarithmic joint predictive density (ljpd). For detailed introduction of these 
metrics, see Chapter 7 of Gelman et al. (2013).

The deviance function for a model with a vector of parameters 
\eqn{\boldsymbol \theta} is defined as
 \deqn{
 D(\boldsymbol \theta) = -2\log p(\mathbf{y} \mid \boldsymbol \theta),
} 
where \eqn{\mathbf{y}:=(y(\mathbf{x}_1), \ldots, y(\mathbf{x}_n))^\top} is a vector of \eqn{n} observations.

\itemize{
\item{The effective number of parameters (see p.172 of Gelman et al. 2013) is defined as
\deqn{
 pD = E_{\boldsymbol \theta| \mathbf{y}}[D(\boldsymbol \theta)] - D(\hat{ \boldsymbol \theta }),
 }
where \eqn{\hat{\boldsymbol \theta} = E_{\boldsymbol \theta | \mathbf{y}}[\boldsymbol \theta]. }
The interpretation is that the effective number of parameters is the ``expected" 
deviance minus the ``fitted" deviance. Higher \eqn{pD} implies more over-fitting with estimate  \eqn{\hat{\boldsymbol \theta}}.
}
\item{The Deviance information criteria (DIC) (see pp. 172-173 of Gelman et al. 2013) is 
\deqn{DIC = E_{\boldsymbol \theta | \mathbf{y}}[D(\boldsymbol \theta)] + pD.
}
DIC approximates Akaike information criterion (AIC) and is more appropriate for hierarchical models than AIC and BIC.
}
\item{The log predictive density (\strong{lpd}) is defined as 
\deqn{ p(y(\mathbf{x}_0) \mid \mathbf{y}) = \int p(y(\mathbf{x}_0) \mid 
\boldsymbol \theta, \mathbf{y}) p(\boldsymbol \theta \mid \mathbf{y}) 
d \boldsymbol \theta,
}
where \eqn{\mathbf{y}:=(y(\mathbf{x}_1), \ldots, y(\mathbf{x}_n))^\top} is a vector of \eqn{n} observations.
\eqn{\boldsymbol \theta} contains correlation
parameters and nugget parameter. This predictive density should be understood as an update of the likelihood since data is treated as prior information now.
With a set of prediction locations \eqn{\mathcal{X}:=\{x_0^i: i=1, \ldots, m\}}. 
The log pointwise predictive density (\strong{lppd}) is defined as
\deqn{lppd = \sum_{i=1}^m \log p(y(\mathbf{x}_0^i) 
\mid \mathbf{y}).} 
The log joint predictive density (\strong{ljpd}) is defined as 
\deqn{ljpd = \log p(y(\mathcal{X})). }
The \code{lppd} is connected to cross-validation, while the \code{ljpd} measures joint uncertainty across prediction locations.
}

}
}
\references{
\itemize{
\item{Gelman, Andrew, John B. Carlin, Hal S. Stern, David B. Dunson, 
Aki Vehtari, and Donald B. Rubin (2013). 
Bayesian Data Analysis, Third Edition. CRC Press.}
}
}
\seealso{
\link{GPBayes-package}, \code{\link{GaSP}}, \code{\link{gp}},
}
\author{
Pulong Ma \email{mpulong@gmail.com}
}
