% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_posterior_m_nn.R
\name{compute_posterior_m_nn}
\alias{compute_posterior_m_nn}
\title{Calculate Posterior Means for nnGP Model}
\usage{
compute_posterior_m_nn(
  hyperparam,
  w,
  GPS_w,
  obs_ord,
  y_obs_ord,
  n_neighbor = 10,
  expand = 5,
  block_size = 10000
)
}
\arguments{
\item{hyperparam}{A set of hyperparameters in the GP model.}

\item{w}{A scaler representing the exposure level for the point of interest
on the CERF.}

\item{GPS_w}{The GPS for all samples when their exposure levels are set
at \code{w}.}

\item{obs_ord}{A matrix of two columns. First column is the observed
exposure levels of all samples; second is the GPS at the observed exposure
levels. The rows are in ascending order for the first column.}

\item{y_obs_ord}{A vector of observed outcome values. The vector is ordered
as \code{obs_ord}.}

\item{n_neighbor}{The number of nearest neighbors on one side
(see also \code{expand}).}

\item{expand}{Scaling factor to determine the total number of nearest
neighbors. The total is \code{2*expand*n_neighbor}.}

\item{block_size}{Number of samples included in a computation block.
Mainly used to balance the speed and memory requirement.
Larger \code{block_size} is faster, but requires more memory.}
}
\value{
A two-column matrix. The first column is the weights assigned to each
nearest neighbor. The second column is the corresponding observed outcome
value. The weight in the last row of this matrix is NA and the observed
outcome value is the estimated posterior mean of the CERF at point \code{w},
which is the weighted sum of all observed outcome values of the neighbors.
}
\description{
Calculates the posterior mean of a point on the CERF based on the nnGP model.
This function also returns the weights assigned to all nearest neighbors when
calculating the posterior mean.
}
\examples{

set.seed(1029)
data <- generate_synthetic_data(sample_size = 150, gps_spec = 3)

# Estimate GPS function
GPS_m <- train_GPS(cov_mt = as.matrix(data[,-(1:2)]),
                   w_all = as.matrix(data$treat))

# Hyperparameter
hyperparam <- c(0.1, 0.2, 1)
n_neighbor <- 10
expand <- 1
block_size <- 10000

# Exposure level
wi <- 0.4

# Estimate GPS for the exposure level
GPS_w <- dnorm(wi,
               mean = GPS_m$e_gps_pred,
               sd = GPS_m$e_gps_std, log = TRUE)

# Order data for easy selection
coord_obs = cbind(data$treat, GPS_m$GPS)
y_use <- data$Y

obs_ord <- coord_obs[order(coord_obs[,1]),]
y_use_ord <- y_use[order(coord_obs[,1])]

val <- compute_posterior_m_nn(hyperparam = hyperparam,
                              w = wi,
                              GPS_w = GPS_w,
                              obs_ord = obs_ord,
                              y_obs_ord = y_use_ord,
                              n_neighbor = n_neighbor,
                              expand = expand,
                              block_size = block_size)

}
