% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_rl_deriv_nn.R
\name{compute_rl_deriv_nn}
\alias{compute_rl_deriv_nn}
\title{Calculate right minus left derivatives for change-point detection in nnGP}
\usage{
compute_rl_deriv_nn(
  w,
  w_obs,
  GPS_m,
  y_obs,
  hyperparam,
  n_neighbor,
  expand,
  block_size,
  kernel_fn = function(x) exp(-x),
  kernel_deriv_fn = function(x) -exp(-x)
)
}
\arguments{
\item{w}{A scalar of exposure level of interest.}

\item{w_obs}{A vector of observed exposure levels of all samples.}

\item{GPS_m}{A data.frame of GPS vectors.
\itemize{
\item Column 1: GPS values.
\item Column 2: Prediction of exposure for covariate of each data
sample (e_gps_pred).
\item Column 3: Standard deviation of  e_gps (e_gps_std).
}}

\item{y_obs}{A vector of observed outcome values.}

\item{hyperparam}{A vector of hyper-parameters in the GP model.}

\item{n_neighbor}{The number of nearest neighbors on one side
(see also \code{expand}).}

\item{expand}{A scaling factor to determine the total number of nearest
neighbors. The total is \code{2*expand*n_neighbor}.}

\item{block_size}{The number of samples included in a computation block.
Mainly used to balance the speed and memory requirement. Larger
\code{block_size} is faster, but requires more memory.}

\item{kernel_fn}{The covariance function. The input is the square of
Euclidean distance.}

\item{kernel_deriv_fn}{The partial derivative of the covariance function.
The input is the square of Euclidean distance.}
}
\value{
A numeric value of the posterior mean of the difference between two one-sided
derivatives.
}
\description{
Calculates the posterior mean of the difference between left- and
right-derivatives at an exposure level for the detection of change points.
nnGP approximation is used.
}
\examples{
\donttest{
set.seed(325)
data <- generate_synthetic_data(sample_size = 200)
GPS_m <- train_gps(cov_mt = data[,-(1:2)],
                   w_all = data$treat,
                   sl_lib = c("SL.xgboost"),
                   dnorm_log = FALSE)

wi <- 12.2

deriv_val <- compute_rl_deriv_nn(w = wi,
                                 w_obs = data$treat,
                                 GPS_m = GPS_m,
                                 y_obs = data$Y,
                                 hyperparam = c(0.2,0.4,1.2),
                                 n_neighbor = 20,
                                 expand = 1,
                                 block_size = 10)
}
}
