% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_posterior_m_nn.R
\name{compute_posterior_m_nn}
\alias{compute_posterior_m_nn}
\title{Calculate posterior means for nnGP model}
\usage{
compute_posterior_m_nn(
  hyperparam,
  w,
  gps_w,
  obs_ord,
  y_obs_ord,
  kernel_fn = function(x) exp(-x^2),
  n_neighbor = 10,
  block_size = 10000
)
}
\arguments{
\item{hyperparam}{A set of hyperparameters in the GP model.}

\item{w}{A scaler representing the exposure level for the point of interest
on the CERF.}

\item{gps_w}{The GPS for all samples when their exposure levels are set
at \code{w}.}

\item{obs_ord}{A matrix of two columns. First column is the observed
exposure levels of all samples; second is the GPS at the observed exposure
levels. The rows are in ascending order for the first column.}

\item{y_obs_ord}{A vector of observed outcome values. The vector is ordered
as \code{obs_ord}.}

\item{kernel_fn}{The covariance function of the GP.}

\item{n_neighbor}{The number of nearest neighbors on one side.}

\item{block_size}{Number of samples included in a computation block.
Mainly used to balance the speed and memory requirement.
Larger \code{block_size} is faster, but requires more memory.}
}
\value{
TODO: The first column is the selected index and the second column is weight.
A two-column matrix. The first column is the weights assigned to each
nearest neighbor. The second column is the corresponding observed outcome
value. The weight in the last row of this matrix is NA and the observed
outcome value is the estimated posterior mean of the CERF at point \code{w},
which is the weighted sum of all observed outcome values of the neighbors.
}
\description{
Calculates the posterior mean of a point on the CERF based on the nnGP model.
This function also returns the weights assigned to all nearest neighbors when
calculating the posterior mean.
}
\keyword{internal}
