% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPCMlasso-package.R
\docType{package}
\name{GPCMlasso-package}
\alias{GPCMlasso-package}
\title{Find DIF in Generalized Partial Credit Models}
\description{
Performs GPCMlasso, a method to identify DIF in Generalized Partial Credit Models. 
A joint parametric model is set up based on an IRT model chosen by the user. Several variables can be considered simultaneously.
For each pair between variable and item, a parametric DIF effect is introduced which
indicates DIF if the respective parameter is selected (estimated to be unequal zero). 
Parameter selection is done using a lasso-type penalization term.
}
\examples{
data(tenseness_small)

## formula for simple model without covariates
form.0 <- as.formula(paste("cbind(",paste(colnames(tenseness_small)[1:5],collapse=","),")~0"))

######
## fit simple RSM where loglikelihood and score function are evaluated parallel on 2 cores
rsm.0 <- GPCMlasso(form.0, tenseness_small, model = "RSM", 
control= ctrl_GPCMlasso(cores=2))
rsm.0

\dontrun{
## formula for model with covariates (and DIF detection)
form <- as.formula(paste("cbind(",paste(colnames(tenseness_small)[1:5],collapse=","),")~."))

######
## fit GPCM model with 10 different tuning parameters
gpcm <- GPCMlasso(form, tenseness_small, model = "GPCM", 
                  control = ctrl_GPCMlasso(l.lambda = 10))
gpcm
plot(gpcm)
pred.gpcm <- predict(gpcm)
trait.gpcm <- trait.posterior(gpcm)

######
## fit RSM, detect differential step functioning (DSF)
rsm.DSF <- GPCMlasso(form, tenseness_small, model = "RSM", DSF = TRUE, 
                     control = ctrl_GPCMlasso(l.lambda = 10))
rsm.DSF
plot(rsm.DSF)

## create binary data set
tenseness_small_binary <- tenseness_small
tenseness_small_binary[,1:5][tenseness_small[,1:5]>1] <- 2

######
## fit and cross-validate Rasch model
set.seed(1860)
rm.cv <- GPCMlasso(form, tenseness_small_binary, model = "RM", cv = TRUE, 
                   control = ctrl_GPCMlasso(l.lambda = 10))
rm.cv
plot(rm.cv)
}
}
\references{
Schauberger, Gunther and Mair, Patrick (2019): A Regularization Approach for the Detection of Differential 
Item Functioning in Generalized Partial Credit Models, \emph{Behavior Research Methods}, to appear
}
\seealso{
\code{\link{GPCMlasso}}
}
\author{
Gunther Schauberger\cr \email{gunther.schauberger@tum.de}
}
\keyword{Credit}
\keyword{DIF}
\keyword{DSF}
\keyword{GPCM}
\keyword{GPCMlasso}
\keyword{Partial}
\keyword{package}
