% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsgp.functions.R
\name{unscaledCorr}
\alias{unscaledCorr}
\title{Calculate an unscaled NSGP correlation matrix}
\usage{
unscaledCorr(Dist.mat, corrModel, gamma = NULL, nu = NULL)
}
\arguments{
\item{Dist.mat}{Distance matrix}

\item{corrModel}{Correlation function specification used for g(.). It can be
either "pow.ex" or "matern".}

\item{gamma}{Power parameter used in powered exponential kernel function. It
must be 0<gamma<=2.}

\item{nu}{Smoothness parameter of the Matern class. It must be a positive
value.}
}
\value{
A matrix
}
\description{
Calculate an unscaled NSGP correlation matrix
}
\examples{
## See examples in vignette:
# vignette("nsgpr", package = "GPFDA")
}
\references{
Konzen, E., Shi, J. Q. and Wang, Z. (2020) "Modeling
  Function-Valued Processes with Nonseparable and/or Nonstationary Covariance
  Structure" <arXiv:1903.09981>.
}
