% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpfr.functions6.R
\name{plot.gpfr}
\alias{plot.gpfr}
\title{Plot GPFR model for either training or prediction}
\usage{
\method{plot}{gpfr}(
  x,
  type = c("raw", "meanFunction", "fitted", "prediction"),
  ylab = "y",
  xlab = "t",
  ylim = NULL,
  realisations = NULL,
  alpha = 0.05,
  colourTrain = 2,
  colourNew = 4,
  mar = c(4.5, 5.1, 2.2, 0.8),
  oma = c(0, 0, 1, 0),
  cex.lab = 1.5,
  cex.axis = 1,
  cex.main = 1.5,
  ...
)
}
\arguments{
\item{x}{Plot GPFR for training or prediction from a given object of 'gpfr'
class.}

\item{type}{Required type of plots. Options are: 'raw',
'meanFunction', 'fitted' and 'prediction'.}

\item{ylab}{Title for the y axis.}

\item{xlab}{Title for the x axis.}

\item{ylim}{Graphical parameter. If NULL (default), it is chosen automatically.}

\item{realisations}{Index vector identifying which training realisations
should be plotted. If NULL (default), all training realisations are plotted. 
For predictions, 'realisations' should be '0' if no training realisation 
is to be plotted.}

\item{alpha}{Significance level used for 'fitted' or 'prediction'. Default is 0.05.}

\item{colourTrain}{Colour for training realisations when 'type' is set to 
'prediction' and 'realisations' is positive.}

\item{colourNew}{Colour for predictive mean for the new curve when 'type' is 
set to 'prediction'.}

\item{mar}{Graphical parameter passed to par().}

\item{oma}{Graphical parameter passed to par().}

\item{cex.lab}{Graphical parameter passed to par().}

\item{cex.axis}{Graphical parameter passed to par().}

\item{cex.main}{Graphical parameter passed to par().}

\item{...}{Other graphical parameters passed to plot().}
}
\value{
A plot.
}
\description{
Plot GPFR model for either training or prediction
}
\examples{
## See examples in vignette:
# vignette("gpfr", package = "GPFDA")
}
