% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findAllSets.R
\name{findAllSets}
\alias{findAllSets}
\title{findAllSets : find all potential systems (a set of
equations) from a given ensemble of potential equations}
\usage{
findAllSets(allFilt, nS = c(3), nPmin = 1, nPmax = 14)
}
\arguments{
\item{allFilt}{A list with:
- a matrix allFilt$Xi of possible formulations for each variable Xi
- a vector allFilt$Npi providing the number of parameters of each formulation Xi}

\item{nS}{A vector providing the number of dimensions that will be used for each
input variables (see Examples 1 and 2). The dimension of the resulting model will
be nVar = sum(nS).}

\item{nPmin}{Corresponds to the minimum number of parameters (and thus
of regressor) of the model}

\item{nPmax}{Corresponds to the maximum number of parameters (and thus
of regressor) of the model}
}
\description{
For each equation to be retrieved, an ensemble
of potential formulation is given. For instance, three formulations
are provided for equation (1), one for equation (2) and two for
equation (3). In this case, six possible sets can be obtained
from it.
The aim of this program is to formulate all the potential
systems from the provided formulation.
}
\examples{
#############
# Example 1 #
#############
allFilt <- list()
allFilt$Np1 <- 1         # only one formulation with one single parameter
allFilt$Np2 <- c(3, 4)   # two potential formulations, one with respectively
# three and four parameters
allFilt$Np3 <- c(2, 4)   # two potential formulations, one with respectively
# two and four parameters
# formulations for variables Xi:
allFilt$X1 <- t(as.matrix(c(0,0,0,1,0,0,0,0,0,0)))
allFilt$X2 <- t(matrix(c(0,-0.85,0,-0.27,0,0,0,0.46,0,0,
                         0,-0.64,0,0,0,0,0,0.43,0,0),
                       ncol=2, nrow=10))
allFilt$X3 <- t(matrix(c(0, 0.52,  0, -1.22e-05,  0, 0, 0.99, 5.38e-05, 0, 0,
                         0, 0.52, 0, 0, 0, 0, 0.99, 0, 0, 0),
                       ncol=2, nrow=10))
findAllSets(allFilt, nS=c(3), nPmin=1, nPmax=14)

}
\author{
Sylvain Mangiarotti
}

