% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictab.R
\name{predictab}
\alias{predictab}
\title{predictab : estimate the models predictability of gPoMo output}
\usage{
predictab(ogp, fullt = NULL, fulldata = NULL, hp = NULL, Nech = 50,
  show = 1, selecmod = NULL, id = 1)
}
\arguments{
\item{ogp}{The output list obtained from gPoMo.}

\item{fullt}{Time vector of the data set for which predictability will be tested}

\item{fulldata}{Data set for which predictability will be tested}

\item{hp}{Time vector of the horizon of prediction}

\item{Nech}{Number of simulations}

\item{show}{Indicates (2) or not (0-1) the algorithm progress}

\item{selecmod}{a vector of the model selected.}

\item{id}{the type of model to identify. id = 1 correspond to the unidentified
models, that is, potentialy chaotic models).}
}
\value{
ErrmodAll A list of matrix $Errmod1, $Errmod2, etc.
providing the forecasting error of each model 1, 2, etc.
Each column corresponds to one simulation starting from
specific initial condition. Each line corresponds to
the the horizon of prediction.
Vectors corresponding to the initial condition time tE
and the horizon of prediction hpE are also provided
in $tE and $hpE, respectively.
}
\description{
The algorithm aims to estimate automatically the predictability
of the models obtained with `gPoMo`.
}
\examples{
# load data
data("Ross76")
# time vector
tin <- Ross76[seq(1, 3000, by = 8), 1]
# single time series
data <- Ross76[seq(1, 3000, by = 8), 3]
# dev.new()
# plot(tin, data, xlab = 'time', ylab = 'y(t)')

# global modelling
# results are put in list outputGPoM
outputGPoM <- gPoMo(data[1:300], tin = tin[1:300], dMax = 2, nS=c(3),
                    show = 0, method = 'rk4',
                    nPmin = 10, nPmax = 12,
                    IstepMin = 150, IstepMax = 151)
#
visuOutGP(outputGPoM)

###########################
# and test predictability #
###########################
outpred <- predictab(outputGPoM, hp = 15, Nech = 30)

# manual visualisation of the outputs (e.g. for model 1):
dev.new()
image(outpred$tE, outpred$hpE, t(outpred$Errmod1),
xlab = 't', ylab = 'hp', main = 'Errmod1')

}
\author{
Sylvain Mangiarotti
}

