% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDatabase.R
\name{createDatabase}
\alias{createDatabase}
\title{Building SQLite database}
\usage{
createDatabase(dbInfo, figs)
}
\arguments{
\item{dbInfo}{List which contains the required information
of the items that will be included in the database.
Three arguments must be specified in the \code{dbInfo}:
\itemize{
\item \code{database_name}: Name of the database.
\item \code{database_params}: List of parameters which will be included in the database.
\item \code{identifiers}: Identifiers for the items which will be displayed on the browser.
These identifiers should appear in the begining of the corresponding figure names, followed by 
an underscore and the type of the plot.
For example, for identifier "geneA", multiple figures may be named as 
"geneA_gene.png", "geneA_abstr.png", and "geneA_reltr.png".
}}

\item{figs}{Character vector containing the figure names.}
}
\value{
Generates an SQLite database named "$database_name.sqlite".
}
\description{
Function for building an SQLite database for displaying 
GP profiles of the selected items on a browser,
enabling to rank them according to their Bayes factors 
and other provided parameters.
For details of using tigreBrowser, please refer to
\url{https://github.com/PROBIC/tigreBrowser} and. 
\url{https://github.com/PROBIC/tigreBrowserWriter}.
}
\examples{
BF=c(3,10,2)
FoldChange=c(0.5,3,5)
dbParams=list("BF"=BF,"Fold change"=FoldChange)
identifiers=c("geneA","geneB","geneC")
dbInfo=list(database_name="testdb","database_params"=dbParams,"identifiers"=identifiers)
figs=c("geneA_gene.png","geneA_abstr.png","geneA_reltr.png","geneB_gene.png",
"geneB_abstr.png","geneB_reltr.png","geneC_gene.png","geneC_abstr.png","geneC_reltr.png")
for (i in seq(1,9)) {
	examplefig=figs[i] 
     png(examplefig)
     plot(c(0, 1), c(0, 1))
     dev.off()
}
createDatabase(dbInfo,figs)

}
\author{
Hande Topa, \email{hande.topa@helsinki.fi}
}
\keyword{database}

