% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clear.R
\name{clear_temp_fils}
\alias{clear_temp_fils}
\alias{clear_repo}
\title{Clear packages and temporary files  from repo build process}
\usage{
clear_temp_fils(repo, checkout = FALSE)

clear_repo(repo, all = TRUE, checkout = FALSE, archivedir = NA)
}
\arguments{
\item{repo}{GRANRepository - The repository to clean}

\item{checkout}{logical - Should the checkouts of packages also be cleared.
Generally this is not necessary (default: FALSE)}

\item{all}{logical - Should temporary artifacts from the build process also be cleared
(via automatically calling clear_temp_fils). Defaults to TRUE}

\item{archivedir}{character - Optional. A directory where build packages
deployed to the repository will be archived. Package versions already in
the archive will not be overwritten.}
}
\value{
The GRANRepository object, ready to be rebuilt.
}
\description{
These are convenience functions which clears the intermediate
files generated during the build process. This is important
when, e.g., building a repository for the first time with
a new version of R.
}
\details{
\code{clear_repo} removes packages deployed into the destination repository,
updates the PACKAGES and PACKAGES.gz files, and resets the build results within the
GRANRepository object. \code{clear_temp_fils} clears
intermediate files from the library location used during building, the temporary
repository, the package staging area, and the store of install- and check-results.
}
\author{
Gabriel Becker
}
