/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.trim;

import java.util.HashMap;
import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.trim.AbstractSingleRecordTrimmer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarcodeSplitter
extends AbstractSingleRecordTrimmer {
    private HashMap<String, String> barcodes;
    private int maxMisMatch = 0;
    private boolean clipOffBarcodes = true;

    public BarcodeSplitter(HashMap<String, String> barcodes, int mism, boolean clip) {
        this.barcodes = barcodes;
        this.maxMisMatch = mism;
        this.clipOffBarcodes = clip;
    }

    public HashMap<String, String> getBarcodeMap() {
        return this.barcodes;
    }

    @Override
    public FastqRecord processRecord(FastqRecord entry) {
        String seq = entry.getSequence();
        for (String label : this.barcodes.keySet()) {
            int codeLength = this.barcodes.get(label).length();
            if (this.maxMisMatch == 0) {
                if (!entry.getSequence().startsWith(this.barcodes.get(label))) continue;
                if (this.clipOffBarcodes) {
                    FastqRecord outentry = new FastqRecord(entry, codeLength, seq.length() - codeLength);
                    outentry.setBarcodeLabel(label);
                    return outentry;
                }
                entry.setBarcodeLabel(label);
                return entry;
            }
            if (this.getMisMatches(this.barcodes.get(label), entry.getSequence(), this.barcodes.get(label).length()) > this.maxMisMatch) continue;
            if (this.clipOffBarcodes) {
                FastqRecord outentry = new FastqRecord(entry, codeLength, seq.length() - codeLength);
                outentry.setBarcodeLabel(label);
                return outentry;
            }
            entry.setBarcodeLabel(label);
            return entry;
        }
        entry.setBarcodeLabel("UNKNOWN");
        return entry;
    }

    private int getMisMatches(String a, String b, int range) {
        int mismatch = 0;
        for (int i = 0; i < range; ++i) {
            mismatch += a.charAt(i) == b.charAt(i) ? 0 : 1;
        }
        return mismatch;
    }
}

