/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.fastq;

import java.util.Collection;
import java.util.Iterator;
import org.usadellab.trimmomatic.fastq.FastqNamePattern;
import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairingValidator {
    private Logger logger;
    private boolean complainedAlready;
    private long offset;

    public PairingValidator(Logger logger) {
        this.logger = logger;
        this.complainedAlready = false;
        this.offset = 0L;
    }

    private boolean validateNames(String name1, String name2) {
        String canon1 = FastqNamePattern.canonicalize(name1);
        String canon2 = FastqNamePattern.canonicalize(name2);
        if (canon1 != null && canon2 != null) {
            return canon1.equals(canon2);
        }
        String[] tokens1 = name1.split(" ");
        String[] tokens2 = name2.split(" ");
        String tok1 = tokens1[0];
        String tok2 = tokens2[0];
        if (tok1.length() != tok2.length()) {
            return false;
        }
        int len = tok1.length();
        for (int i = 0; i < len; ++i) {
            char ch2;
            char ch1 = tok1.charAt(i);
            if (ch1 == (ch2 = tok2.charAt(i)) || ch1 == '1' && ch2 == '2') continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean validatePair(FastqRecord rec1, FastqRecord rec2) {
        block8: {
            if (rec1 != null) {
                if (rec2 != null) {
                    String name2;
                    String name1 = rec1.getName();
                    if (!this.validateNames(name1, name2 = rec2.getName())) {
                        if (!this.complainedAlready) {
                            this.complainedAlready = true;
                            this.logger.warnln("WARNING: Pair validation failed at record: " + this.offset);
                            this.logger.warnln("         Forward read: " + name1);
                            this.logger.warnln("         Reverse read: " + name2);
                        }
                        return false;
                    }
                    break block8;
                } else {
                    if (!this.complainedAlready) {
                        this.complainedAlready = true;
                        String name1 = rec1.getName();
                        this.logger.warnln("WARNING: Pair validation failed at record: " + this.offset);
                        this.logger.warnln("         Forward read: " + name1);
                        this.logger.warnln("         No more reverse reads");
                    }
                    return false;
                }
            }
            if (rec2 != null) {
                if (!this.complainedAlready) {
                    this.complainedAlready = true;
                    String name2 = rec2.getName();
                    this.logger.warnln("WARNING: Pair validation failed at record: " + this.offset);
                    this.logger.warnln("         No more forward reads");
                    this.logger.warnln("         Reverse read: " + name2);
                }
                return false;
            }
        }
        ++this.offset;
        return true;
    }

    public boolean validatePairs(Collection<FastqRecord> col1, Collection<FastqRecord> col2) {
        Iterator<FastqRecord> iter1 = col1.iterator();
        Iterator<FastqRecord> iter2 = col2.iterator();
        while (iter1.hasNext() || iter2.hasNext()) {
            FastqRecord rec2;
            FastqRecord rec1 = iter1.hasNext() ? iter1.next() : null;
            if (this.validatePair(rec1, rec2 = iter2.hasNext() ? iter2.next() : null)) continue;
            return false;
        }
        return true;
    }
}

