% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_contour_grid.R
\name{normal.contour.grid}
\alias{normal.contour.grid}
\title{Draws the density of a grid copula with contours and normal marginals}
\usage{
normal.contour.grid(
  gc,
  x1 = seq(-3, 3, length.out = 21),
  x2 = seq(-3, 3, length.out = 21)
)
}
\arguments{
\item{gc}{a grid type copula object.}

\item{x1}{indicates the place for lines on axis x1.}

\item{x2}{indicates the place for lines on axis x2.}
}
\value{
Returns a graph.
}
\description{
Draws the density of a grid copula with contours and normal marginals
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 10
m <- 10
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
normal.contour.grid(gc = copula.grid)
}
