% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau_grid.R
\name{tau.grid}
\alias{tau.grid}
\title{Calculates the Kendall's tau concordance measure for a grid type copula}
\usage{
tau.grid(gc)
}
\arguments{
\item{gc}{a grid type copula object.}
}
\value{
Returns a number with the corresponding value.
}
\description{
Calculates the Kendall's tau concordance measure for a grid type copula
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 10
m <- 10
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
tau.grid(gc = copula.grid)
}
