% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{GROAN.run}
\alias{GROAN.run}
\title{Compare Genomic Regressors on a Noisy Dataset}
\usage{
GROAN.run(nds, wb, nds.test = NULL, run.id = createRunId())
}
\arguments{
\item{nds}{a GROAN.NoisyDataSet object, containing the data (genotypes, phenotypes and so forth) plus a \code{noiseInjector} function}

\item{wb}{a GROAN.Workbench object, containing the regressors to be tested together with the description of the experiment}

\item{nds.test}{either a GROAN.NoisyDataSet or a list of GROAN.NoisyDataSet. The regression model(s) trained
on \code{nds} will be tested on \code{nds.test}}

\item{run.id}{an alphanumeric string identifying this specific run. If not passed it is generated using \link{createRunId}}
}
\value{
a \code{GROAN.Result} object
}
\description{
This function runs the experiment described in a \link[=createWorkbench]{GROAN.Workbench} object,
training regressor(s) on the data contained in a \link[=createNoisyDataset]{GROAN.NoisyDataSet} object
via parameter \code{nds}. The prediction accuracy is estimated either through crossvalidation
or on separate test dataset supplied via parameter \code{nds.test}.
It returns a \code{GROAN.Result} object, which have a \link[=summary.GROAN.Result]{summary}
function for quick inspection and can be fed to \link{plotResult} for visual comparisons.
In case of crossvalidation the test dataset in the result object will report the \code{[CV]}
suffix.\cr
The experiment statistics are computed via \link{measurePredictionPerformance}.\cr
Each time this function is invoked it will refer to a \code{runId} - an alphanumeric string identifying
each specific run. The \code{runId} is usually generated internally, but it is possible to pass it if
the intention is to join results from different runs for analysis purposes.
}
\examples{
\dontrun{
#Complete examples are found in the vignette
vignette('GROAN.vignette', package='GROAN')

#Minimal example
#1) creating a noisy dataset with normal noise
nds = createNoisyDataset(
  name = 'PEA KI, normal noise',
  genotypes = GROAN.KI$SNPs,
  phenotypes = GROAN.KI$yield,
  noiseInjector = noiseInjector.norm,
  mean = 0,
  sd = sd(GROAN.KI$yield) * 0.5
)

#2) creating a GROAN.WorkBench using default regressor and crossvalidation preset
wb = createWorkbench()

#3) running the experiment
res = GROAN.run(nds, wb)

#4) examining results
summary(res)
plotResult(res)
}
}
\seealso{
\link{measurePredictionPerformance}
}
