% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsnSubset.R
\name{gsnSubset}
\alias{gsnSubset}
\title{gsnSubset}
\usage{
gsnSubset(object, distance = NULL, vertex_names = c(), subnet_names = NULL)
}
\arguments{
\item{object}{A \code{GSNData} object.}

\item{distance}{Specifies a distance metric to use for subsetting. Defaults to the \code{default_distance}.}

\item{vertex_names}{A character vector specifying the vertex names/gene sets to include in the \code{GSNData}
subset object.}

\item{subnet_names}{A character vector specifying the names of the subnets to include in the \code{GSNData}
subset object.}
}
\value{
A new \code{GSNData} object is returned containing a subset of the vertices and subnets from the original
\code{GSNData} object. For a given distance, the following data are subsetted for the included vertices and
copied:

\item{\code{$distances[[distance]]$matrix}}{The raw distance matrix, subsetted.}
\item{\code{$distances[[distance]]$pared}}{The pared distance matrix, subsetted.}
\item{\code{$distances[[distance]]$edges}}{The edge list, subsetted}
\item{\code{$distances[[distance]]$vertex_subnets}}{The vertex assignments for each subnet, subsetted.}
\item{\code{$distances[[distance]]$clusters}}{The cluster assignments for each subnet, subsetted (for
hierarchical clustering).}
\item{\code{$distances[[distance]]$optimal_extreme}}{Character vector of length 1 indicating whether min or max distances
are close in the raw distance matrix.}
\item{\code{$distances[[distance]]$pared_optimal_extreme}}{Character vector of length 1  indicating whether min
or max distances are close in the pared distance matrix.}

The hclust object generated by hierarchical clustering is not currently subsetted or copied.

The \code{default_distance} is set as whichever distance matrix is copied. Currently, this function only supports
copying a single distance matrix.

The following pathways data are copied:

\item{\code{$pathways$data}}{Pathways results, subsetted.}
\item{\code{$pathways$type}}{The type of pathways results, copied.}
\item{\code{$pathways$id_col}}{The identifier, copied.}
\item{\code{$pathways$stat_col}}{Statistical column name, copied.}
\item{\code{$pathways$sig_order}}{The significance order of the pathways results, based on the stat_column; are
the pathways results to be sorted by significance from 'loToHi' (most significant values are low) or 'hiToLo'
(most significant values high)?}
}
\description{
Create a subset GSNData object, containing only a subset of vertices or subnets.
}
\details{
This function is useful for subsetting a single subnet, or a small set of subnets for the purpose of
plotting just that subnet.
}
\seealso{
\code{\link{GSNData}()}
}
