% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DGSA.R
\name{flatten_normal_tiss}
\alias{flatten_normal_tiss}
\title{Flatten normal tissues}
\usage{
flatten_normal_tiss(normal_tiss)
}
\arguments{
\item{normal_tiss}{A normal tissue data gene expression matrix.
The columns should be the samples and the rows should be the genes.}
}
\value{
A gene expression matrix containing the flattened
version of the vectors.
}
\description{
Given a matrix containing the expression values of
\code{n} healthy tissue samples, it produces the flattened vector matrix
as reported in "Disease-specific genomic analysis: identifying
the signature of pathology biology".
}
\examples{
\donttest{
normal_tissue_matrix <- matrix(stats::rnorm(36), nrow=6)
flatten_normal_tiss(normal_tissue_matrix)
}
}
