% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_inspector.R
\name{setup.inspector}
\alias{setup.inspector}
\title{Importing a QC-configuration file into R}
\usage{
setup.inspector(config.file, validate = TRUE)
}
\arguments{
\item{config.file}{character. Path to a configuration (.ini) file. For a sample configuration file, see \code{\link{get.config}}.}

\item{validate}{logical. Whether to validate the object.}
}
\value{
returns a new instance of \linkS4class{Inspector} class.
}
\description{
To run a QC in GWASinspector, first generate a config file using \code{\link{get.config}}, and edit it to suit your requirements.
Next, use the function \code{\link{setup.inspector}} to check the configuration file and import it into R.
This will create an object of the inspector class, which can then be processed using \code{\link{run.inspector}}.
}
\examples{
config.file <- get.config(tempdir())
job <- setup.inspector(config.file , validate = FALSE)
job

}
