% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{RMSE}
\alias{RMSE}
\title{Calculate the root mean squared error (RMSE) of prediction}
\usage{
RMSE(y_pred, y_true, normalized = FALSE)
}
\arguments{
\item{y_pred}{A vector of predicted output values.}

\item{y_true}{A vector of true output values.}

\item{normalized}{An optional boolean: if \code{TRUE}, the RMSE is
normalized by dividing it by the standard deviation of \code{y_true}.}
}
\value{
The RMSE or normalized RMSE.
}
\description{
Calculate the root mean squared error (RMSE) of prediction
}
\examples{
\dontshow{
x <- borehole$x
y <- borehole$y
theta <- c(
  5.767699e+01, 0.000000e+00, 0.000000e+00, 1.433571e-06,
  0.000000e+00, 2.366557e-06, 1.695619e-07, 2.454376e-09
)
alpha <- c(
  1.110223e-16, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 2.494862e-03, 0.000000e+00
)
cor_par <- data.frame(Theta = theta, Alpha = alpha)
rownames(cor_par) <- colnames(borehole$x)
sp_var <- 38783.7
borehole_fit <- GaSPModel(
  x = borehole$x, y = borehole$y,
  reg_model = ~1, cor_family = "PowerExponential",
  cor_par = cor_par, random_error = FALSE,
  sp_var = sp_var
)
borehole_pred <- Predict(
  GaSP_model = borehole_fit,
  x_pred = borehole$x_pred,
  generate_coefficients = TRUE
)
borehole_cv <- CrossValidate(borehole_fit)
}
RMSE(borehole_pred$y_pred$Pred, borehole$y_true)

RMSE(borehole_cv$Pred, y)
}
