% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotQQ}
\alias{PlotQQ}
\title{Normal quantile-quantile (Q-Q) plot.}
\usage{
PlotQQ(y_pred, y, y_name = "y")
}
\arguments{
\item{y_pred}{A data frame of predicted output values
made by \code{Predict} or \code{CrossValidate}.}

\item{y}{A vector of length equal to the number of rows in \code{y_pred}
containing the true output values.}

\item{y_name}{An optional character string containing the output variable name
(for labels).}
}
\value{
No return value, generates plots.
}
\description{
Normal quantile-quantile (Q-Q) plot of the standardized residuals
of predictions from \code{Predict} or \code{CrossValidate}.
}
\examples{
\dontshow{
x <- borehole$x
y <- borehole$y
theta <- c(
  5.767699e+01, 0.000000e+00, 0.000000e+00, 1.433571e-06,
  0.000000e+00, 2.366557e-06, 1.695619e-07, 2.454376e-09
)
alpha <- c(
  1.110223e-16, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 2.494862e-03, 0.000000e+00
)
cor_par <- data.frame(Theta = theta, Alpha = alpha)
rownames(cor_par) <- colnames(borehole$x)
sp_var <- 38783.7
borehole_fit <- GaSPModel(
  x = borehole$x, y = borehole$y,
  reg_model = ~1, cor_family = "PowerExponential",
  cor_par = cor_par, random_error = FALSE,
  sp_var = sp_var
)
borehole_cv <- CrossValidate(borehole_fit)
}
PlotQQ(borehole_cv, y)
}
