% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRSin.R
\name{GRSin}
\alias{GRSin}
\title{Geographical representativeness score in situ}
\usage{
GRSin(
  Species_list,
  Occurrence_data,
  Raster_list,
  Pro_areas = NULL,
  Gap_Map = FALSE
)
}
\arguments{
\item{Species_list}{A vector of characters with the species names to calculate the GRSex metrics.}

\item{Occurrence_data}{A data frame object with the species name, geographical coordinates,
and type of records (G or H) for a given species}

\item{Raster_list}{A list of rasters representing the species distribution models for the species list provided
in \var{Species_list}. The order of rasters in this list must match the same order as \var{Species_list}.}

\item{Pro_areas}{A raster file representing protected areas information.
If Pro_areas=NULL the function will use a protected area raster file
provided for your use after run GetDatasets()}

\item{Gap_Map}{logical, if \code{TRUE} the function will calculate gap maps for each species analyzed and will return a list
with two slots ERSin and gap_maps}
}
\value{
This function returns a data frame with two columns:

\tabular{lcc}{
species \tab Species name \cr
GRSin \tab GRSin value calculated\cr
}
}
\description{
The GRSin process provides a geographic measurement of the proportion of a species’ range that can be considered
to be conserved in protected areas. The GRSin compares the area of the distribution model located within protected areas versus
the total area of the model, considering comprehensive conservation to have been accomplished only when the entire distribution
occurs within protected areas.
}
\examples{
##Obtaining occurrences from example
data(CucurbitaData)
##Obtaining species names from the data
Cucurbita_splist <- unique(CucurbitaData$species)
##Obtaining Raster_list
data(CucurbitaRasters)
CucurbitaRasters <- raster::unstack(CucurbitaRasters)
##Obtaining protected areas raster
data(ProtectedAreas)
#Running GRSin
GRSin_df <- GRSin(Species_list = Cucurbita_splist,
                    Occurrence_data = CucurbitaData,
                    Raster_list = CucurbitaRasters,
                    Pro_areas=ProtectedAreas,
                    Gap_Map=FALSE)


}
\references{
Khoury et al. (2019) Ecological Indicators 98:420-429. doi: 10.1016/j.ecolind.2018.11.016
}
