% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageSpecs.R
\name{PackageSpecs}
\alias{PackageSpecs}
\title{Function for viewing built-in GaussSuppression specs}
\usage{
PackageSpecs(x = NULL, printTable = FALSE)
}
\arguments{
\item{x}{the character name or index of the spec to be returned. If \code{NULL} (default),
returns list of all specs}

\item{printTable}{Logical value (default \code{FALSE}). If \code{TRUE}, prints a table
description of all specs. Primarily used for documentation purposes.}
}
\value{
returns a spec (if \code{!is.null(x)}), list of all specs (if \code{is.null(x)}
and \code{printTable = FALSE}), or markdown table describing all specs (if \code{printTable = TRUE}).
}
\description{
Functions to retrieve the built-in specs. These can be retrieved using either
numerical indices or by specifying the spec name, see Details.
}
\details{
The following table summarizes the built-in specs. Columns represent
different specs, and rows represent the parameter settings.\tabular{lllll}{
    \tab \strong{smallCountSpec} \tab \strong{dominanceSpec} \tab \strong{fewContributorsSpec} \tab \strong{kDisclosureSpec} \cr
   \strong{primary} \tab PrimaryDefault \tab DominanceRule \tab NContributorsRule \tab KDisclosurePrimary \cr
   \strong{protectZeros} \tab TRUE \tab FALSE \tab FALSE \tab FALSE \cr
   \strong{candidates} \tab CandidatesDefault \tab CandidatesNum \tab CandidatesNum \tab DirectDisclosureCandidates \cr
   \strong{singleton} \tab SingletonDefault \tab SingletonUniqueContributor \tab SingletonUniqueContributor \tab SingletonDefault \cr
   \strong{extend0} \tab TRUE \tab FALSE \tab FALSE \tab TRUE \cr
   \strong{preAggregate} \tab is.null(freqVar) \tab !is.null(charVar) \tab !is.null(charVar) \tab is.null(freqVar) \cr
   \strong{extraAggregate} \tab FALSE \tab TRUE \tab TRUE \tab FALSE \cr
   \strong{secondaryZeros} \tab FALSE \tab FALSE \tab FALSE \tab 1 \cr
   \strong{domWeightMethod} \tab  \tab "default" \tab  \tab  \cr
   \strong{singletonMethod} \tab  \tab "numttHTT" \tab "numttHTT" \tab "anySumNOTprimary" \cr
}
}
\examples{
PackageSpecs()
PackageSpecs(1)
PackageSpecs("smallCountSpec")
PackageSpecs(printTable = TRUE)
}
