% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_over_time.R
\name{plot_over_time}
\alias{plot_over_time}
\title{Plot the frequencies of all ancestors over time}
\usage{
plot_over_time(frequencies, focal_location)
}
\arguments{
\item{frequencies}{A tibble containing four columns: \code{time},
\code{location}, \code{ancestor}, \code{frequency}. A fifth colum
\code{population} can be included if the tibble is the result of
\code{simulate_admixture_migration}.}

\item{focal_location}{Location (in Morgan) where to plot the allele
frequencies.}
}
\value{
a ggplot2 object
}
\description{
This function plots the frequency of all ancestors over time at
a specific location on the chromosome, after performing a simulation.
}
\examples{
pop <- simulate_admixture(pop_size = 1000,
                          number_of_founders = 10,
                          total_runtime = 11,
                          morgan = 1,
                          markers = 0.5)
require(ggplot2)
plot_over_time(frequencies = pop$frequencies,
               focal_location = 0.5)
}
