% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_ld.R
\name{calculate_ld}
\alias{calculate_ld}
\title{Calculate linkage disequilibrium statistics
This function calculates two matrices, once containing all pairwise
linkage disequilibrium (ld) values, and one matrix containing all pairwise r
statistics}
\usage{
calculate_ld(pop, sampled_individuals = 10, markers = NA, verbose = FALSE)
}
\arguments{
\item{pop}{focal population}

\item{sampled_individuals}{Number of individuals randomly sampled to
calculate the LD matrices}

\item{markers}{vector of markers. If a single number is used, that number of
markers is randomly placed along the genome.}

\item{verbose}{display verbose output, default is FALSE.}
}
\value{
An object containing two items:
\item{ld_matrix}{
  Pairwise ld statistics for all markers
}
\item{rsq_matrix}{
  Pairwise rsq statistics for all markers
}
}
\description{
Calculate linkage disequilibrium statistics
This function calculates two matrices, once containing all pairwise
linkage disequilibrium (ld) values, and one matrix containing all pairwise r
statistics
}
\examples{
wildpop =  simulate_admixture(
   module = ancestry_module(number_of_founders = 10, morgan = 1),
   pop_size = 1000,
   total_runtime = 10)

ld_results <- calculate_ld(pop = wildpop,
                           markers = 10)

plot(ld_results$ld_matrix~ld_results$dist_matrix,
     pch = 16,
     xlab="Distance between markers",
     ylab = "Linkage Disequilibrium")
}
