% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusion_label.R
\docType{class}
\name{FusionLabel}
\alias{FusionLabel}
\title{Class "FusionLabel"}
\description{
Defines the allowed labels for the \link{Mf}s of the fuzzy inputs or output in the \link{Fis} "Fusion"
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{very_low}}{\link{character} vector (read-only), The very_low label}

\item{\code{low}}{\link{character} vector (read-only), The low label}

\item{\code{average}}{\link{character} vector (read-only), The average label}

\item{\code{high}}{\link{character} vector (read-only), The high label}

\item{\code{very_high}}{\link{character} vector (read-only), The very_high label}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-get_labels}{\code{FusionLabel$get_labels()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_labels"></a>}}
\if{latex}{\out{\hypertarget{method-get_labels}{}}}
\subsection{Method \code{get_labels()}}{
Get the allowed labels depending on the granularity in the \link{Fis}\cr
for granularity 2, allowed labels are: [low, high]\cr
for granularity 3, allowed labels are: [low, average, high]\cr
for granularity 4, allowed labels are: [very_low, low, high, very_high]\cr
for granularity 5, allowed labels are: [very_low, low, average, high, very_high]
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FusionLabel$get_labels(granularity)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{granularity}}{\link{integer} value, The granularity of the fuzzy inputs or output in the \link{Fis} (value in range [2, 5])}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{character} vector, The allowed labels for the granularity
}
}
}
