% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SGAT.R
\name{zenith}
\alias{zenith}
\title{Solar Zenith Angle}
\usage{
zenith(sun, lon, lat)
}
\arguments{
\item{sun}{list of solar time and declination computed by \code{solar}.}

\item{lon}{vector of longitudes.}

\item{lat}{vector latitudes.}
}
\value{
A vector of solar zenith angles (degrees) for the given
locations and times.
}
\description{
Calculate the solar zenith angle for given times and locations
}
\details{
\code{zenith} uses the solar time and declination calculated by
\code{solar} to compute the solar zenith angle for given times and
locations, using the same methods as
\url{www.esrl.noaa.gov/gmd/grad/solcalc/}.  This function does not
adjust for atmospheric refraction see \code{\link{refracted}}.
}
\examples{
## Approx location of Sydney Harbour Bridge
lon <- 151.211
lat <- -33.852
## Solar zenith angle for noon on the first of May 2000
## at the Sydney Harbour Bridge
s <- solar(as.POSIXct("2000-05-01 12:00:00","EST"))
zenith(s,lon,lat)
}
\seealso{
\code{\link{solar}}
}

