% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fplot.R
\name{fplot}
\alias{fplot}
\title{Plot line or bar graphic}
\usage{
fplot(
  data,
  type = "bar",
  x,
  y,
  groups,
  xlab = NULL,
  ylab = NULL,
  glab = NULL,
  legend = "top",
  sig = NULL,
  error = "ste",
  limits = NULL,
  brakes = NULL,
  xbrks = NULL,
  gbrks = NULL,
  color = TRUE
)
}
\arguments{
\item{data}{Output from ger_testcomp function}

\item{type}{Type of graphic. "bar" or "line"}

\item{x}{Axis x variable}

\item{y}{Axis y variable}

\item{groups}{Group variable}

\item{xlab}{Title for the axis x}

\item{ylab}{Title for the axis y}

\item{glab}{Title for the legend}

\item{legend}{the position of legends ("none", "left", "right", "bottom", "top", or two-element numeric vector)}

\item{sig}{Column with the significance}

\item{error}{Show the error bar ("ste" or "std").}

\item{limits}{limits of the y axis}

\item{brakes}{break of the y axis}

\item{xbrks}{axis brakes labels in string with double space}

\item{gbrks}{legend label in string with double space}

\item{color}{colored figure (TRUE), otherwise black & white (FALSE)}
}
\value{
Line o bar plot
}
\description{
Function use the dtsm function for plot the results
}
\examples{
 

\dontrun{

library(GerminaR)
library(dplyr)
data <- prosopis \%>\% mutate(across(c(nacl, temp, rep), as.factor))
smr <- ger_summary(SeedN = "seeds", evalName = "D", data = data)

aov <- aov(grp ~ nacl*temp, smr)

mc <- ger_testcomp(aov = aov
                   , comp = c("nacl", "temp")
                   )
                   
data <- mc$table
                    
 fplot(data = data
       , type = "line"
       , x = "temp"
       , y = "grp"
       , groups = "nacl"
       , limits = c(0,150)
       , brakes = 20
       , color = FALSE
       )
                   
} 
}
