% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghfd_get_available_tickers_from_file.R
\name{ghfd_get_available_tickers_from_file}
\alias{ghfd_get_available_tickers_from_file}
\title{Function to get available tickers from downloaded zip file}
\usage{
ghfd_get_available_tickers_from_file(out.file)
}
\arguments{
\item{out.file}{Name of downloaded file with HFT data from Bovespa}
}
\value{
A dataframe with the  number of trades for each ticker found in file
}
\description{
This function will read the zip file downloaded from Bovespa and output
a numeric vector where the names of the elements represents the different tickers
and the numeric values as the number of trades for each ticker
}
\examples{

## get file from package (usually this would be been downloaded from the ftp)
out.file <- system.file("extdata", 'NEG_OPCOES_20151126.zip', package = "GetHFData")

df.tickers <- ghfd_get_available_tickers_from_file(out.file)

print(head(df.tickers))
}

