% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rating_distribution.R
\name{get_rating_distribution}
\alias{get_rating_distribution}
\title{Get Rating Distribution from Goodreads}
\usage{
get_rating_distribution(file_path)
}
\arguments{
\item{file_path}{A character string specifying the path to the file containing Goodreads book IDs.}
}
\value{
A named list where each element contains the rating distribution for a book.
}
\description{
This function takes a file path containing Goodreads book IDs and retrieves
the rating distribution for each book.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Run the function
rating_distributions <- get_rating_distribution(temp_file)
print(rating_distributions)

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
