% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape_books.R
\name{scrape_books}
\alias{scrape_books}
\title{Scrape book details from Goodreads}
\usage{
scrape_books(book_ids_path, use_parallel = FALSE, num_cores = 4)
}
\arguments{
\item{book_ids_path}{Path to a text file containing book IDs.}

\item{use_parallel}{Logical indicating whether to scrape in parallel (default is FALSE).}

\item{num_cores}{Number of CPU cores to use for parallel scraping (default is 4).}
}
\value{
A data frame containing scraped book details.
}
\description{
This function scrapes details of books using their IDs from Goodreads.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Run the function (with a small delay to avoid overwhelming the server)
result <- scrape_books(temp_file, use_parallel = FALSE)
print(head(result))
# Clean up: remove the temporary file
file.remove(temp_file)
}
}
