% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_plots.R
\name{sentiment_histogram}
\alias{sentiment_histogram}
\title{Create a histogram of sentiment scores}
\usage{
sentiment_histogram(sentiment_df)
}
\arguments{
\item{sentiment_df}{A data frame containing the output from analyze_sentiment.}
}
\value{
A ggplot object representing the histogram.
}
\description{
This function creates a histogram of sentiment scores for all reviews.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Run the scrape_reviews function
reviews <- scrape_reviews(temp_file, num_reviews = 10, use_parallel = FALSE)

# Check if reviews were successfully scraped
if (nrow(reviews) > 0) {
  # Perform sentiment analysis
  sentiment_results <- analyze_sentiment(reviews, lexicon = "afinn")

  # Create histogram of sentiment scores
  sentiment_hist <- sentiment_histogram(sentiment_results)

  # Display the plot
  print(sentiment_hist)

  # Optionally, save the plot
  # ggsave("sentiment_hist.png", sentiment_hist, width = 8, height = 6)
} else {
  cat("No reviews found. Cannot create sentiment histogram.\n")
}

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
