% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNonlinearity.R
\name{addNonlinearity}
\alias{addNonlinearity}
\alias{addNonlinearity.negbin}
\title{Add a nonlinear function to the model}
\usage{
addNonlinearity(
  model,
  variable,
  spline_fn,
  flex_param = 2:7,
  min_fn = AIC,
  sig_level = 0.05,
  verbal = FALSE,
  workers,
  ...
)

\method{addNonlinearity}{negbin}(model, ...)
}
\arguments{
\item{model}{The model that is to be evaluated and adapted for non-linearity}

\item{variable}{The name of the parameter that is to be tested for non-linearity.
\emph{Note} that the variable should be included plain (i.e. as a linear variable)
form in the model.}

\item{spline_fn}{Either a string or a function that is to be used
for testing alternative non-linearity models}

\item{flex_param}{A \code{vector} with values that are to be tested as the
default second parameter for the non-linearity function that you want to
evaluate. This defaults to 2:7, for the \code{\link[splines]{ns}()} it tests
the degrees of freedom ranging between 2 and 7.}

\item{min_fn}{This is the function that we want to minimized if the variable supports
the non-linearity assumption. E.g. \code{\link[stats:AIC]{BIC}()} or
\code{\link[stats]{AIC}}, note that the \code{\link[stats:AIC]{BIC}()} will in the majority of cases
support a lower complexity than the \code{\link[stats]{AIC}()}.}

\item{sig_level}{The significance level for which the non-linearity is deemed
as significant, defaults to 0.05.}

\item{verbal}{Set this to \code{TRUE} if you want print statements with the
anova test and the chosen knots.}

\item{workers}{The function tries to run everything in parallel. Under some
circumstances you may want to restrict the number of parallel threads to less
than the default \code{\link[parallel]{detectCores}() - 1}, e.g. you may run out of memory
then you can provide this parameter. If you do not want to use parallel then
simply set workers to \code{FALSE}. The cluster created using \code{\link[parallel]{makeCluster}()}
function.}

\item{...}{Passed onto internal \code{\link{prNlChooseDf}()} function.}
}
\description{
This function takes a model and adds a non-linear function if
the likelihood-ratio supports this (via the
\code{\link[stats]{anova}(..., test = "chisq")} test for \pkg{stats}
while for \pkg{rms} you need to use the \code{\link[rms:rms.trans]{rcs}()} spline
that is automatically evaluated for non-linearity).
}
\examples{
library(Greg)
data("melanoma", package = "boot", envir = environment())

library(dplyr)
melanoma <- mutate(melanoma, 
                   status = factor(status,
                                   levels = 1:3,
                                   labels = c("Died from melanoma", 
                                              "Alive", 
                                              "Died from other causes")),
                   ulcer = factor(ulcer,
                                  levels = 0:1,
                                  labels = c("Absent", "Present")),
                   time = time/365.25, # All variables should be in the same time unit
                   sex = factor(sex,
                                levels = 0:1,
                                labels = c("Female", "Male")))

library(survival)
model <- coxph(Surv(time, status == "Died from melanoma") ~ sex + age,
  data = melanoma
)

nl_model <- addNonlinearity(model, "age",
  spline_fn = "pspline",
  verbal = TRUE,
  workers = FALSE
)
# Note that there is no support for nonlinearity in this case
}
