import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;


public class Hadoop {
	private String hostname=null;
	private String username=null;
	private Connection conn=null;
	private String keyPath = null;
	
	public Hadoop(String hostname, String username, String key){
		this.hostname=hostname;
		this.username=username;
		keyPath=key;
	}
	

	public boolean connect(){
		conn = new Connection(hostname);

		try
		{
			conn.connect();

			if(conn.isAuthMethodAvailable(username, "publickey")){
				File key = new File(keyPath);

				if (key.exists())
				{
					boolean res = conn.authenticateWithPublicKey(username, key, null);
				

					if (res != true){
						System.err.println("Authentication failed. Please setup a login with RSA Keys and without password");
						return(false);
					}
					return(true);
				}
			}
			return(false);
			
		}
	catch(Exception e)
		{
			e.printStackTrace();
			return(false);
		}
	}
	
	
	public String send(String msg)throws Exception {
		String ret ="";
    	Session sess = conn.openSession();
			
		sess.execCommand(msg);


		InputStream stdout = new StreamGobbler(sess.getStdout());
		InputStream stderr = new StreamGobbler(sess.getStderr());
		
		BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
		BufferedReader stderrReader = new BufferedReader(new InputStreamReader(stderr));
		
		while (true)
		{
			String line = br.readLine();
			if (line == null)
				break;
			ret=ret.concat(line+ "\n");
		}
		
		boolean noErr=true;
		String err="";
		while (true)
		{
			String line = stderrReader.readLine();
			if(noErr && line!=null){
				err="Here is the output from stderr:\n";
				noErr=false;
			}
			if (line == null)
				break;
			err=err.concat(line + "\n");
		}
		if(!noErr)
			throw new RemoteSshException(err);

		sess.close();
		return ret;
	  }
	
	public void upload(String[] from, String to)throws IOException{
		SCPClient client =new SCPClient(conn);
		client.put(from, to);
	}
	
	public void download(String from, String to) throws IOException{
		SCPClient client =new SCPClient(conn);
		client.get(from, to);
	}
	
	public void close()
	{
		/* Close the connection */

		conn.close();
	}
	
	/**
	 * 
	 * @param args[0] "upload"  or "download"
	 * @param args[1] hostname 
	 * @param args[2]username 
	 * @param args[3] Path to RSA-key (/home/malte/.ssh/id_rsa) 
	 * @param args[4] file to up-/download
	 * @param args[5] Path to download or path to upload in dfs
	 * to generate RSA Keys with windows:
	 * Please generate RSA Keys with Puttygen(ie. http://the.earth.li/~sgtatham/putty/latest/x86/puttygen.exe)
	 *	Klick on Generate. This will generate a private/public RSA keypair.
	 * Change the Comment to your username @ yourComputer, dont enter a Pasword!
     * Click on Conversions/Export OpenSSH Key and save it to the path added to args[3].
	 * Now add the Text in the "Public Key for pasting into OpenSSH authorized_keys file" to a new line to ~/.ssh/authorized_keys on the server where to execute gridR
 	 */
	
	public static void main(String[] args)
	{	
		//for (int i = 0; i < args.length; i++) {System.out.println(args[i]);}
		
		if(args.length==5 || args.length==6){
		  try {
			  						//hostname username key (/home/malte/.ssh/id_rsa)
			Hadoop client = new Hadoop(args[1], args[2], args[3]);
			client.connect();
			//make remotedir
			
			String remPath ="/tmp/hadoop"+ System.currentTimeMillis();
			
			client.send("mkdir -p "+ remPath);

			String[] up=null;
			if((args[0].contains("upload"))){
				up = new String[]{args[4]};
				//upload file to remote host
				client.upload(up, remPath);
				
				//upload file to dfs
				client.send("hadoop dfs -put "+ remPath + args[4].substring(args[4].lastIndexOf("/")) + " " + args[5]);
				}
			else
				if((args[0].contains("download"))){
					//download file to remote host
					client.send("hadoop dfs -get "+ args[4] + " "+ remPath);

					//download that file
					client.download(remPath + args[4].substring(args[4].lastIndexOf("/")), args[5]);
				}
				else
					System.err.println("wrong command at args[0], only up- and download is suported");
					
			
			
			
			//client.send("cd " + args[4] + "&& rm " + args[9] + "*");
			client.close();
		  } catch (Exception e) {
			  //System.err.println("SSH Connection Error:"+ e.getMessage());
				e.printStackTrace();
		  }
		}
		else
			System.out.println("Wrong usage of MySSh.");
		
	}
		
}
