package de.fhg.iais.kd.gridr.interfaces;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;


public class SshDownload {
	private String hostname=null;
	private String username=null;
	private Connection conn=null;
	private String keyPath = null;
	
	public SshDownload(String hostname, String username, String key){
		this.hostname=hostname;
		this.username=username;
		keyPath=key;
	}
	
	/**
	 * connects to hostname
	 * @return
	 */
	public boolean connect(){
		conn = new Connection(hostname);

		try
		{
			conn.connect();

			if(conn.isAuthMethodAvailable(username, "publickey")){
				File key = new File(keyPath);

				if (key.exists())
				{
					boolean res = conn.authenticateWithPublicKey(username, key, null);

					if (res != true){
						System.err.println("Authentication failed. Please setup a login with RSA Keys and without password");
						return(false);
					}
					return(true);
				}
			}
			return(false);
			
		}
	catch(Exception e)
		{
			e.printStackTrace();
			return(false);
		}
	}
	
	/**
	 * executes the command msg on remote side
	 * @param msg	Message to execute
	 * @throws Exception
	 */
	public void send(String msg)throws Exception {
    	  Session sess = conn.openSession();
			
		sess.execCommand(msg);


		InputStream stdout = new StreamGobbler(sess.getStdout());
		InputStream stderr = new StreamGobbler(sess.getStderr());
		
		BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
		BufferedReader stderrReader = new BufferedReader(new InputStreamReader(stderr));
		
		while (true)
		{
			String line = br.readLine();
			if (line == null)
				break;
			System.out.println(line);
		}
		
		boolean begin=true;
		while (true)
		{
			String line = stderrReader.readLine();
			if(begin && line!=null){
				System.err.println("Here is the output from stderr:");
				begin=false;
			}
			if (line == null)
				break;
			System.err.println(line);
		}

		sess.close();
	  }

	/**
	 * downlaods a file
	 * @param from	remote File
	 * @param to	local Directory
	 * @throws IOException
	 */
	public void download(String from, String to) throws IOException{
		SCPClient client =new SCPClient(conn);
		client.get(from, to);
	}
	
	/**
	 * closes the connection
	 */
	public void close()
	{
		/* Close the connection */

		conn.close();
	}
	
	/**
	 * download files via Trilead Ssh with the use of an authentication Key and delete it if !debug
	 * @param args[0] ip
					args[1] username
					args[2] Path to ssh AuthKey
					args[3] localDir where to Download
					args[4] remoteDir
					args[5] debug 0/1
					args[6] 1. file to download
					[args[7+] other files to download]
					
	 */
	public static void main(String[] args)
	{	
		if(args.length==11){
		  try {
			SshDownload client = new SshDownload(args[0], args[1], args[2]);
			client.connect();
			for(int i=6;i<args.length;i++)
			{
				//get File i
				client.download(args[4] + args[i], args[3]);
				
				//delete file on server if !debug
				if(args[5].contains("0")){
					client.send("cd " + args[4] + "&& rm " + args[i]);
				}
			}
			client.close();
		  } catch (Exception e) {
				e.printStackTrace();
				//write error to yName in localDir
				createFileFromString(args[3]+ args[6],"SSH Connection Error:"+ e.getMessage());
		  }
		}
		else
			System.out.println("Wrong usage of SshDownload.");
		
	}
	
	private static File createFileFromString(String name, String code) {
		// create file from  code
		
		Writer fw = null;
		try {
			fw = new FileWriter(name);
			fw.write(code);

		} catch (IOException e) {
			System.err.println("Cannot create local File:"+ name);

		} finally {
			if (fw != null)
				try {
					fw.close();
				} catch (IOException e) {
				}
		}
		return new File(name);
	}
		
}
