% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Glacier_Disch}
\alias{Glacier_Disch}
\title{Glacier discharge conceptual model}
\usage{
Glacier_Disch(
       model,
       inputData,
       initCond,
       param
       )
}
\arguments{
\item{model}{numeric integer with the model's choice. The current HBV.IANIGLA version
only supports the \strong{S08} approach.
 \itemize{
  \item 1:\strong{S08} glacier storage and release model.
  }

  \if{html}{\figure{glacier_discharge_hbv.png}{options: width=200}}}

\item{inputData}{numeric matrix with two columns:

 \strong{Model 1}
 \itemize{
 \item \code{column_1}: snow water equivalent above the glacier \eqn{[mm/\Delta t]}.
 The series can be obtained from the \link{SnowGlacier_HBV} function output.
 \item \code{column_2}:  melted snow + melted ice + rainfall \eqn{[mm/\Delta t]}. This
 series comes from the \strong{TotScal} column in the \link{SnowGlacier_HBV}
 function output.
 }}

\item{initCond}{numeric value with the initial glacier reservoir
water content \strong{\code{SG}} \eqn{[mm]}.}

\item{param}{numeric vector with the following values:

\strong{Model 1 (S08)}
 \itemize{
 \item \code{KGmin}: minimal outflow rate \eqn{[1/\Delta t]}.
 \item \code{dKG}:  maximum outflow rate increase \eqn{[1/\Delta t]}.
 \item \code{AG}: scale factor \eqn{[mm]}.
 }}
}
\value{
Numeric matrix with the following columns:

\strong{Model 1 (S08)}
\itemize{
  \item \code{Q}: glacier discharge \eqn{[mm/\Delta t]}.
  \item \code{SG}: glacier's bucket water storage content series \eqn{[1/\Delta t]}.
}
}
\description{
Implement the conceptual water storage and release formulation for
glacier runoff routing. The current model version follows the approach proposed
by \cite{Stahl et al. (2008)} (hereafter S08) for the Bridge River basin. Note that
the bucket storage and release concepts for glacier runoff modeling are also
described in \cite{Jansson et al. (2002)}.
}
\examples{
# The following is a toy example. I strongly recommend to see
# the package vignettes in order to improve your skills on HBV.IANIGLA

## Create an input data and run the module
DataMatrix <- cbind(
                    runif(n = 100, min = 0, max = 50),
                    runif(n = 100, min = 0, max = 200)
                    )

dischGl    <- Glacier_Disch(model = 1, inputData = DataMatrix,
                           initCond = 100, param = c(0.1, 0.9, 10))

}
\references{
Jansson, P., Hock, R., Schneider, T., 2003. The concept of glacier storage: a review.
J. Hydrol., Mountain Hydrology and Water Resources 282, 116–129.
https://doi.org/10.1016/S0022-1694(03)00258-0

Stahl, K., Moore, R.D., Shea, J.M., Hutchinson, D., Cannon, A.J., 2008. Coupled
modelling of glacier and streamflow response to future climate scenarios.
Water Resour. Res. 44, W02422. https://doi.org/10.1029/2007WR005956
}
