% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCV.R
\name{HCV}
\alias{HCV}
\title{Hierarchical Clustering from Vertex-links}
\usage{
HCV(
  geometry_domain,
  feature_domain,
  linkage = "ward",
  diss = "none",
  adjacency = FALSE,
  dist_method = "euclidean"
)
}
\arguments{
\item{geometry_domain}{one of the three formats: (i) \emph{n} by \emph{d} matrix (NA not allowed), (ii)  a \code{SpatialPolygonsDataFrame} object defining polygons, (iii) a matrix with 0-1 value adjacency (with \code{adjacency=TRUE})}

\item{feature_domain}{either (i) \emph{n} by \emph{p} matrix (NA allowed) for \emph{n} samples with \emph{p} attributes, or (ii) \emph{n} by \emph{n} matrix (NA not allowed) with dissimilarity between \emph{n} samples (with \code{diss = 'precomputed'})}

\item{linkage}{the agglomeration method to be used, one of "ward", "single", "complete", "average" (= UPGMA), "weight" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC). Default is \code{'ward'}.}

\item{diss}{character indicating if \code{feature_domain} is a dissimilarity matrix: 'none' for not dissimilarity, and 'precomputed' for dissimilarity. Default is 'none'.}

\item{adjacency}{logical indicating if \code{geometry_domain } is a adjacency matrix. Default is FALSE.}

\item{dist_method}{the distance measure to be used when \code{feature_domain} is not a dissimilarity matrix (\code{diss ='none'}), one of "euclidean", "correlation", "abscor", "maximum", "manhattan", "canberra", "binary" or "minkowski".  Default is \code{'euclidean'}.}
}
\value{
An object of class \code{hclust} which describes the tree produced by the clustering process. See the documentation in \code{hclust}.
}
\description{
This function implements the hierarchical clustering for spatial data. It modified typically used hierarchical agglomerative clustering algorithms for introducing the spatial homogeneity, by considering geographical locations as vertices and converting spatial adjacency into whether a shared edge exists between a pair of vertices.
}
\details{
\code{geometry_domain} can be a user-specifid adjacency matrix, an \emph{n} by \emph{d} matrix with geographical coordinates for point-level data, or a \code{SpatialPolygonsDataFrame} object defining polygons for areal data. If an adjacency matrix is given, the user should use \code{adjacency=TRUE}.
}
\examples{
set.seed(0)
pcase <- synthetic_data(3,30,0.02,100,2,2)
HCVobj <- HCV(pcase$geo,  pcase$feat)
smi <- getCluster(HCVobj,method="SMI")
oldpar <- par(no.readonly = TRUE)  
par(mfrow=c(2,2))
labcolor  <-  (pcase$labels+1)\%\%3+1
plot(pcase$feat,  col  =  labcolor,  pch=19,  xlab  =  'First  attribute', 
  ylab  =  'Second  attribute',  main  =  'Feature  domain')
plot(pcase$geo,  col  =  labcolor,  pch=19,  xlab  =  'First  attribute', 
  ylab  =  'Second  attribute',  main  =  'Geometry  domain')
plot(pcase$feat,  col=factor(smi),pch=19,  xlab  =  'First  attribute', 
  ylab  =  'Second  attribute',main  =  'Feature  domain')
plot(pcase$geo,  col=factor(smi),pch=19,  xlab  =  'First  attribute', 
  ylab  =  'Second  attribute',main  =  'Geometry  domain')
par(oldpar)

}
\references{
Carvalho, A. X. Y., Albuquerque, P. H. M., de Almeida Junior, G. R., and Guimaraes, R. D. (2009). Spatial hierarchical clustering. Revista Brasileira de Biometria, 27(3), 411-442.
}
\seealso{
\code{\link{hclust}}
}
\author{
ShengLi Tzeng and Hao-Yun Hsu.
}
