% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM.R
\name{EMlasso}
\alias{EMlasso}
\title{EM algorithm for lasso penalty}
\usage{
EMlasso(X, y, lambda, maxSteps = 1000, intercept = TRUE,
  model = c("linear", "logistic"), burn = 50, threshold = 1e-08,
  eps = 1e-05, epsCG = 1e-08)
}
\arguments{
\item{X}{the matrix (of size n*p) of the covariates.}

\item{y}{a vector of length n with the response.}

\item{lambda}{a sequence of l1 penalty regularization term. If no sequence is provided, the function computes his own sequence.}

\item{maxSteps}{Maximal number of steps for EM algorithm.}

\item{intercept}{If TRUE, there is an intercept in the model.}

\item{model}{"linear" or "logistic"}

\item{burn}{Number of steps before thresholding some variables to zero.}

\item{threshold}{Zero tolerance. Coefficients under this value are set to zero.}

\item{eps}{Epsilon for the convergence of the EM algorithm.}

\item{epsCG}{Epsilon for the convergence of the conjugate gradient.}
}
\value{
A list containing :
\describe{
  \item{step}{Vector containing the number of steps of the algorithm for every \code{lambda}.}
  \item{variable}{List of vector of the same length as \code{lambda}. The i-th item contains the index of non-zero coefficients for the i-th \code{lambda} value.}
  \item{coefficient}{List of vector of the same length as \code{lambda}. The i-th item contains the non-zero coefficients for the i-th \code{lambda} value.}
  \item{lambda}{Vector containing the \code{lambda} values.}
  \item{mu}{Intercept.}
}
}
\description{
EM algorithm for lasso penalty
}
\examples{
dataset=simul(50,100,0.4,1,10,matrix(c(0.1,0.9,0.02,0.02),nrow=2))
result=EMlasso(dataset$data,dataset$response)
# Obtain estimated coefficient in matrix format
coefficient = listToMatrix(result)
}
\author{
Quentin Grimonprez, Serge Iovleff
}
\seealso{
\code{\link{EMcvlasso}}
}

