% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lars.R
\name{HDfusion}
\alias{HDfusion}
\title{Fusion algorithm}
\usage{
HDfusion(
  X,
  y,
  maxSteps = 3 * min(dim(X)),
  intercept = TRUE,
  eps = .Machine$double.eps^0.5
)
}
\arguments{
\item{X}{the matrix (of size n*p) of the covariates.}

\item{y}{a vector of length n with the response.}

\item{maxSteps}{Maximal number of steps for lars algorithm.}

\item{intercept}{If TRUE, there is an intercept in the model.}

\item{eps}{Tolerance of the algorithm.}
}
\value{
An object of type \code{\link{LarsPath}}. \code{\link{LarsPath-class}}.
}
\description{
It performs the lars algorithm for solving a special case of lasso problem.
It is a linear regression problem with a l1-penalty on the difference of two successive coefficients.
}
\examples{
set.seed(10)
dataset <- simul(50, 10000, 0.4, 10, 50, matrix(c(0.1, 0.8, 0.02, 0.02), nrow = 2))
result <- HDfusion(dataset$data, dataset$response)
}
\references{
Efron, Hastie, Johnstone and Tibshirani (2003) "Least Angle Regression" (with discussion) Annals of Statistics
}
\seealso{
LarsPath HDlars
}
\author{
Quentin Grimonprez
}
