% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvlars.R
\name{HDcvlars}
\alias{HDcvlars}
\title{cross validation}
\usage{
HDcvlars(
  X,
  y,
  nbFolds = 10,
  index = seq(0, 1, by = 0.01),
  mode = c("fraction", "lambda"),
  maxSteps = 3 * min(dim(X)),
  partition = NULL,
  intercept = TRUE,
  eps = .Machine$double.eps^0.5
)
}
\arguments{
\item{X}{the matrix (of size n*p) of the covariates.}

\item{y}{a vector of length n with the response.}

\item{nbFolds}{the number of folds for the cross-validation.}

\item{index}{Values at which prediction error should be computed. When mode = "fraction",
this is the fraction of the saturated |beta|.
The default value is seq(0,1,by=0.01). When mode="lambda", this is values of lambda.}

\item{mode}{Either "fraction" or "lambda". Type of values containing in partition.}

\item{maxSteps}{Maximal number of steps for lars algorithm.}

\item{partition}{partition in nbFolds folds of y. Must be a vector of same size than y containing the index of folds.}

\item{intercept}{If TRUE, there is an intercept in the model.}

\item{eps}{Tolerance of the algorithm.}
}
\value{
A list containing
\describe{
  \item{cv}{Mean prediction error for each value of index.}
  \item{cvError}{Standard error of cv.}
  \item{minCv}{Minimal cv criterion.}
  \item{minIndex}{Value of index for which the cv criterion is minimal.}
  \item{index}{Values at which prediction error should be computed. This is the fraction of the saturated |beta|.
The default value is seq(0,1,by=0.01).}
  \item{maxSteps}{Maximum number of steps of the lars algorithm.}
}
}
\description{
cross validation function for lars algorithm
}
\examples{
dataset <- simul(50, 10000, 0.4, 10, 50, matrix(c(0.1, 0.8, 0.02, 0.02), nrow = 2))
result <- HDcvlars(dataset$data, dataset$response, 5)
}
\author{
Quentin Grimonprez
}
