% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/AllMethod.R
\docType{methods}
\name{getVarorder}
\alias{getVarorder}
\alias{getVarorder,VB-method}
\alias{getVarorder,HMMVB-method}
\title{Accessor for 'varorder' slot}
\usage{
getVarorder(object)

\S4method{getVarorder}{VB}(object)

\S4method{getVarorder}{HMMVB}(object)
}
\arguments{
\item{object}{Object of class "VB" or "HMMVB".}
}
\description{
This function outputs the ordering of the variable blocks.
}
\examples{
# accessing varorder in instance of class VB
Vb <- vb(2, dim=10, bdim=c(4,6), numst=c(3,11), varorder=list(c(1:4),c(5:10)))
getVarorder(Vb)

# accessing varorder in instance of class HMMVB 
data("sim3")
Vb <- vb(2, dim=40, bdim=c(10,30), numst=c(3,5), varorder=list(c(1:10),c(11:40)))
set.seed(12345)
hmmvb <- hmmvbTrain(sim3[,1:40], VbStructure=Vb)
getVarorder(hmmvb)  
    
}
