% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HEMDAG.1.0.0.R
\docType{methods}
\name{Multilabel.F.measure}
\alias{Multilabel.F.measure}
\alias{F.measure.multilabel}
\alias{F.measure.multilabel,matrix,matrix-method}
\title{Multilabel F-measure}
\usage{
F.measure.multilabel(target, predicted, b.per.example = FALSE)

\S4method{F.measure.multilabel}{matrix,matrix}(target, predicted,
  b.per.example = FALSE)
}
\arguments{
\item{target}{matrix with the target multilabels: rows correspond to examples and columns to classes.
\eqn{target[i,j]=1} if example \eqn{i} belongs to class \eqn{j}, \eqn{target[i,j]=0} otherwise}

\item{predicted}{a numeric matrix with predicted values (scores): rows correspond to examples and columns to classes}

\item{b.per.example}{boolean. 
\itemize{
\item \code{TRUE}: results are returned for each example;
\item \code{FALSE}: only the average results are returned
}}
}
\value{
Two different outputs respect to the input paramenter \code{b.per.example}:
\itemize{
\item \code{b.per.example==FALSE}: a list with a single element average. A named vector with average precision (P), recall (R), 
	specificity (S), F-measure (F), average F-measure (avF) and Accuracy (A) across examples. F is the F-measure computed as the 
	harmonic mean between the average precision and recall; av.F is the F-measure computed as the average across examples.
	\item \code{b.per.example==FALSE}: a list with two elements:
		\enumerate{
			\item average: a named vector with average precision (P), recall (R), specificity (S), F-measure (F), average F-measure (avF) 
			and Accuracy (A) across examples; 
			\item per.example: a named matrix with the Precision (P), Recall (R), Specificity (S), Accuracy (A), F-measure (F) and 
			av.F-measure (av.F) for each example. Row names correspond to examples, column names correspond respectively to Precision (P), Recall (R), 
			Specificity (S), Accuracy (A), F-measure (F) and av.F-measure (av.F)
		}
}
}
\description{
Method for computing Precision, Recall, Specificity, Accuracy and F-measure for multiclass multilabel classification
}
\examples{
data(labels);
data(scores);
data(graph);
root <- root.node(g);
L <- L[,-which(colnames(L)==root)];
S <- S[,-which(colnames(S)==root)];
S[S>0.7] <- 1;
S[S<0.7] <- 0;
FMM <- F.measure.multilabel(L,S);
}
