% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dblassoHIMA.R
\name{dblassoHIMA}
\alias{dblassoHIMA}
\title{High-dimensional mediation analysis with de-biased lasso penalty}
\usage{
dblassoHIMA(
  X,
  M,
  Y,
  COV = NULL,
  topN = NULL,
  scale = TRUE,
  FDRcut = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{X}{a vector of exposure. Do not use \code{data.frame} or \code{matrix}.}

\item{M}{a \code{data.frame} or \code{matrix} of high-dimensional mediators. Rows represent samples, columns represent variables.}

\item{Y}{a vector of outcome. Can be either continuous or binary (0-1). Do not use \code{data.frame} or \code{matrix}.}

\item{COV}{a \code{data.frame} or \code{matrix} of covariates dataset for testing the association M ~ X and Y ~ M.}

\item{topN}{an integer specifying the number of top markers from sure independent screening.
Default = \code{NULL}. If \code{NULL}, \code{topN} will be \code{ceiling(n/log(n))},
where \code{n} is the sample size. If the sample size is greater than topN (pre-specified or calculated), all
mediators will be included in the test (i.e. low-dimensional scenario).}

\item{scale}{logical. Should the function scale the data? Default = \code{TRUE}.}

\item{FDRcut}{HDMT pointwise FDR cutoff applied to select significant mediators. Default = \code{0.05}.}

\item{verbose}{logical. Should the function be verbose? Default = \code{FALSE}.}
}
\value{
A data.frame containing mediation testing results of significant mediators (FDR <\code{FDRcut}).
\describe{
    \item{Index: }{mediation name of selected significant mediator.}
    \item{alpha_hat: }{coefficient estimates of exposure (X) --> mediators (M) (adjusted for covariates).}
    \item{alpha_se: }{standard error for alpha.}
    \item{beta_hat: }{coefficient estimates of mediators (M) --> outcome (Y) (adjusted for covariates and exposure).}
    \item{beta_se: }{standard error for beta.}
    \item{IDE: }{mediation (indirect) effect, i.e., alpha*beta.}
    \item{rimp: }{relative importance of the mediator.}
    \item{pmax: }{joint raw p-value of selected significant mediator (based on HDMT pointwise FDR method).}
}
}
\description{
\code{dblassoHIMA} is used to estimate and test high-dimensional mediation effects using de-biased lasso penalty.
}
\examples{
\dontrun{
# Note: In the following examples, M1, M2, and M3 are true mediators.
data(himaDat)

# Y is continuous and normally distributed
# Example:
head(himaDat$Example1$PhenoData)

dblassohima.fit <- dblassoHIMA(
  X = himaDat$Example1$PhenoData$Treatment,
  Y = himaDat$Example1$PhenoData$Outcome,
  M = himaDat$Example1$Mediator,
  COV = himaDat$Example1$PhenoData[, c("Sex", "Age")],
  scale = FALSE, # Disabled only for simulation data
  FDRcut = 0.05,
  verbose = TRUE
)
dblassohima.fit
}

}
\references{
Perera C, Zhang H, Zheng Y, Hou L, Qu A, Zheng C, Xie K, Liu L.
HIMA2: high-dimensional mediation analysis and its application in epigenome-wide DNA methylation data.
BMC Bioinformatics. 2022. DOI: 10.1186/s12859-022-04748-1. PMID: 35879655; PMCID: PMC9310002
}
