% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UNItoGLS.R
\name{multiUNItoGLS}
\alias{multiUNItoGLS}
\title{Translate Multiple UNIFORMAT Strings to GL Strings}
\usage{
multiUNItoGLS(UniformatArray, prefix = "HLA-", pre = TRUE)
}
\arguments{
\item{UniformatArray}{A data frame or vector of UNIFORMAT formatted strings. If 'UniformatArray' is a data frame with more than one column, the first column should contain only identifiers. If 'UniformatgArray' is a vector, it should contain only UNIFORMAT strings.}

\item{prefix}{A character string of the desired locus prefix (default is "HLA-").}

\item{pre}{A logical. If 'pre' is TRUE, all allele names will be prefixed with 'prefix'. If 'pre' is FALSE, no allele names will be prefixed.}
}
\value{
A version of 'UniformatArray' in which the UNIFORMAT data have been converted to GL String format. If a 'UniformatArray' was a data frame, a data frame is returned. If 'UniformatArray' was a vector, a vector is returned.
}
\description{
Translate a data frame or vector of UNIFORMAT strings to GL Strings.
}
\note{
This function does not return the GL String "?" operator, as the "?" operator has no cognate in UNIFORMAT.
}
\examples{
multiUNItoGLS(unname(as.vector(UNIFORMAT.example[2]))[[1]])
multiUNItoGLS(UNIFORMAT.example[1:2])

}
\references{
Nunes Tissue Antigens 2007;69(s1):203-205 https://doi.org/10.1111/j.1399-0039.2006.00808.x

Mack et al. HLA 2023;102(2):206-212 https://doi.org/10.1111/tan.15126
}
