% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{dotplot_diag}
\alias{dotplot_diag}
\title{Dot plots for influence diagnostics}
\usage{
dotplot_diag(
  x,
  cutoff,
  name = c("cooks.distance", "mdffits", "covratio", "covtrace", "rvc", "leverage"),
  data,
  index = NULL,
  modify = FALSE,
  ...
)
}
\arguments{
\item{x}{values of the diagnostic of interest}

\item{cutoff}{value(s) specifying the boundary for unusual values of the 
diagnostic. The cutoff(s) can either be supplied by the user, or automatically
calculated using measures of internal scaling if \code{cutoff = "internal"}.}

\item{name}{what diagnostic is being plotted
(one of \code{"cooks.distance"}, \code{"mdffits"}, \code{"covratio"}, 
\code{"covtrace"}, \code{"rvc"}, or \code{"leverage"}).
This is used for the calculation of "internal" cutoffs.}

\item{data}{data frame to use (optional)}

\item{index}{optional parameter to specify index (IDs) of \code{x} values.
If \code{NULL}(default), values will be indexed in the order of the vector 
passed to \code{x}.}

\item{modify}{specifies the \code{geom} to be used to produce a 
space-saving modification: either \code{"dotplot"} or \code{"boxplot"}}

\item{...}{other arguments to be passed to \code{ggplot()}}
}
\description{
This is a function that can be used to create (modified) dotplots for the
diagnostic measures.  The plot allows the user to understand the distribution
of the diagnostic measure and visually identify unusual cases.
}
\note{
The resulting plot uses \code{coord_flip} to rotate the plot, so when
adding customized axis labels you will need to flip the names 
between the x and y axes.
}
\examples{
data(sleepstudy, package = 'lme4')
fm <- lme4::lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

#Observation level deletion and diagnostics
obs.infl <- hlm_influence(fm, level = 1)

dotplot_diag(x = obs.infl$cooksd, cutoff = "internal", name = "cooks.distance", modify = FALSE)

dotplot_diag(x = obs.infl$mdffits, cutoff = "internal", name = "cooks.distance", modify = FALSE)

# Subject level deletion and diagnostics
subject.infl  <- hlm_influence(fm, level = "Subject")

dotplot_diag(x = subject.infl$cooksd, cutoff = "internal",
             name = "cooks.distance", modify = FALSE)
             
dotplot_diag(x = subject.infl$mdffits, cutoff = "internal", name = "mdffits", modify = "dotplot")
}
\author{
Adam Loy \email{loyad01@gmail.com}
}
\keyword{hplot}
