% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readHFD.R
\name{readHFDweb}
\alias{readHFDweb}
\title{read an HFD data file directly from the web as an R data.frame}
\usage{
readHFDweb(CNTRY = NULL, item = NULL, username = NULL, password = NULL,
  fixup = TRUE, Update = NULL)
}
\arguments{
\item{CNTRY}{character string of the HFD short code. Only one!}

\item{item}{character string of the data product code, which is the base file name, but excluding the country code and file extension \code{.txt}. For instance, \code{"mabRR"} or \code{"tfrVHbo"}. If you're not sure, then leave it blank and a list will be shown. Only one item!}

\item{username}{your HFD usernames, which is usually the email address you registered with}

\item{password}{your HFD password. Don't make this a sensitive password, as things aren't encrypted.}

\item{fixup}{logical. Should columns be made more user-friendly, e.g., forcing Age to be integer?}

\item{Update}{character string of 8-digit date code of the format \code{"YYYYMMDD"}. Defaults to most recent update.}

\item{...}{optional arguments passed to \code{read.table}. Probably not needed.}
}
\value{
data.frame of the given HFD data file, modified in some friendly ways.
}
\description{
Read HFD data directly from the web. This function is useful for short reproducible examples, or to make code guaranteed to always use the most up to date version of a particular HFD data file. For working with the entire HFD for a comparative study, it may be more efficient to download the full HFD and read in the elements using \code{readHFD()}. This function returns data formatted in the same way as \code{readHFD()}, that is, with Age columns (and others) converted to integer, and with open age group identifiers stored in a new logical column called \code{OpenInterval}. This reduces user burden somewhat, and facilitates direct use of functionality such as \code{log2mat()}. It is faster to specify \code{CNTRY} and \code{item} as arguments than to make the function figure out what's available. For repeated calls to this function, you can pass your username and password in as variables without having to include these in you R script by using \code{userInput()}-- see example. The user also has the option of querying particular updates from the HFD revision history. If you wish to specify a particular update, you must know the date that a particular country was updated, in the format \code{"YYYYMMDD"}. These dates differ between countries, so keep a good record if you wish your work to be reproducible to that extent (as well as lightweight)!
}
\details{


You need to register for HFD to use this function: \url{www.humanfertility.org}. It is advised to pass in your credentials as named vectors rather than directly as character strings, so that they are not saved directly in your code. See examples. One option is to just save them in your Rprofile file.
}
\examples{
### # this will ask you to enter your login details in the R console
### DAT <- readHFDweb("JPN","tfrRR")
###
### # ----------------------------------------
### # this is a good way to reuse your login credentials without
### # having to reveal them in your R script.
### # if you want to do this in batch then I'm
### # afraid you'll have to find a clever way to
### # pass in your credentials without an interactive
### # session, such as reading them in from a system file of your own.
### myusername <- userInput()
### mypassword <- userInput()
### DAT <- readHMDweb("USA","mltper_1x1",mypassword,myusername)
###
### #-----------------------------------------
### # this also works, but you'll need to make two selections,
### # plus enter data in the console twice:
### DAT <- readHFDweb()
}

