% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendata.r
\name{gendata_FAM}
\alias{gendata_FAM}
\title{Generate Simulated Data with Factor Analysis Model}
\usage{
gendata_FAM(n, muj, A, sd_g = 0, stdx = FALSE)
}
\arguments{
\item{n}{Number of observations.}

\item{muj}{C by p matrix, with row c representing y = c, and column j representing \eqn{x_j}.
Used to specify \code{y}.}

\item{A}{Factor loading matrix of size p by p, see details.}

\item{sd_g}{Numeric value indicating noise level \eqn{\delta}, see details.}

\item{stdx}{Logical; if \code{TRUE}, data \code{X} is standardized to have \code{mean = 0} and \code{sd = 1}.}
}
\value{
A list contains input matrix \code{X}, response variables \code{y},
covariate matrix \code{SGM} and \code{muj} (standardized if \code{stdx = TRUE}).
}
\description{
This function generates inputs \code{X} given by the response variable \code{y} 
using a multivariate normal model.
}
\details{
The means of each covariate \eqn{x_j} depend on \code{y} specified by the 
matrix \code{muj}; the covariate matrix \eqn{\Sigma} of the multivariate normal 
is equal to \eqn{AA^t\delta^2I}, where \code{A} is the factor loading matrix
and \eqn{\delta} is the noise level.
}
\examples{
## feature #1: marginally related feature
## feature #2: marginally unrelated feature, but feature #2 is correlated with feature #1
## feature #3-5: marginally related features and also internally correlated
## feature #6-10: noise features without relationship with the y

set.seed(12345)
n <- 100
p <- 10

means <- rbind(
  c(0, 1, 0),
  c(0, 0, 0),
  c(0, 0, 1),
  c(0, 0, 1),
  c(0, 0, 1)
) * 2

means <- rbind(means, matrix(0, p - 5, 3))

A <- diag(1, p)
A[1:5, 1:3] <- rbind(
  c(1, 0, 0),
  c(2, 1, 0),
  c(0, 0, 1),
  c(0, 0, 1),
  c(0, 0, 1)
)

dat <- gendata_FAM(n, means, A, sd_g = 0.5, stdx = TRUE)
ggplot2::qplot(dat$y, bins = 6)
corrplot::corrplot(cor(dat$X))

}
\seealso{
\code{\link{gendata_MLR}}
}
