% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htrx_nfeatures.R
\name{htrx_nfeatures}
\alias{htrx_nfeatures}
\title{Total number of features for HTRX}
\usage{
htrx_nfeatures(nsnp, max_int = NULL, htr = FALSE)
}
\arguments{
\item{nsnp}{a positive integer giving the number of single nucleotide polymorphisms (SNPs) included in the haplotypes.}

\item{max_int}{a positive integer which specifies the maximum number of SNPs that can interact.
If no value is given (by default), interactions between all the SNPs will be considered.}

\item{htr}{logical. If \code{htr=TRUE}, the function returns the total number of
features for HTR. By default, \code{htr=FALSE}.}
}
\value{
\code{htrx_nfeatures} returns a positive integer giving the total number
of features that each analysis includes.
}
\description{
The total number of features in principle from haplotypes (i.e. interactions between SNPs)
generated by Haplotype Trend Regression with eXtra flexibility (HTRX) .
}
\details{
The total number of features in principle is \ifelse{html}{\out{3<sup>nsnp</sup>}}{\eqn{2^nsnp}}-1
for haplotypes containing interactions between all different numbers of SNPs.
However, if \code{max_int < nsnp}, i.e. only the interactions between at most \code{max_int} SNPs are investigated,
there will be fewer total number of features.
}
\examples{
## the total number of haplotypes consisted of 6 SNPs
## for at most 3-SNP interactions
htrx_nfeatures(nsnp=6,max_int=3)
}
