% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainHVT.R
\name{trainHVT}
\alias{trainHVT}
\title{Constructing Hierarchical Voronoi Tessellations}
\usage{
trainHVT(
  dataset,
  min_compression_perc = NA,
  n_cells = NA,
  depth = 1,
  quant.err = 0.2,
  projection.scale = 10,
  normalize = FALSE,
  seed = 279,
  distance_metric = c("L1_Norm", "L2_Norm"),
  error_metric = c("mean", "max"),
  quant_method = c("kmeans", "kmedoids"),
  scale_summary = NA,
  diagnose = FALSE,
  hvt_validation = FALSE,
  train_validation_split_ratio = 0.8
)
}
\arguments{
\item{dataset}{Data frame. A data frame, with numeric columns (features) will be used for training the model.}

\item{min_compression_perc}{Numeric. An integer, indicating the minimum compression percentage to be achieved for the dataset. 
It indicates the desired level of reduction in dataset size compared to its original size.}

\item{n_cells}{Numeric. An integer, indicating the number of cells per hierarchy (level).}

\item{depth}{Numeric. An integer, indicating the number of levels. A depth of 1 means no hierarchy (single level), 
while higher values indicate multiple levels (hierarchy).}

\item{quant.err}{Numeric. A number indicating the quantization error threshold.
A cell will only breakdown into further cells if the quantization error of the cell is 
above the defined quantization error threshold.}

\item{projection.scale}{Numeric. A number indicating the scale factor for the tessellations to visualize the sub-tessellations
well enough. It helps in adjusting the visual representation of the hierarchy to make the sub-tessellations more visible.}

\item{normalize}{Logical. A logical value indicating if the dataset should be normalized. When set to TRUE, 
scales the values of all features to have a mean of 0 and a standard deviation of 1 (Z-score).}

\item{seed}{Numeric. A Random Numeric Seed to preserve the repeatability.}

\item{distance_metric}{Character. The distance metric can be L1_Norm(Manhattan) or L2_Norm(Eucledian). L1_Norm is selected by default.
The distance metric is used to calculate the distance between an n dimensional point and centroid.}

\item{error_metric}{Character. The error metric can be mean or max. max is selected by default. 
max will return the max of m values and mean will take mean of m values where
each value is a distance between a point and centroid of the cell.}

\item{quant_method}{Character. The quantization method can be kmeans or kmedoids. Kmeans uses means (centroids) as cluster centers
while Kmedoids uses actual data points (medoids) as cluster centers. kmeans is selected by default.}

\item{scale_summary}{List. A list with user-defined mean and standard deviation values for all the features in the dataset. 
Pass the scale summary when normalize is set to FALSE.}

\item{diagnose}{Logical. A logical value indicating whether user wants to perform diagnostics on the model. 
Default value is FALSE.}

\item{hvt_validation}{Logical. A logical value indicating whether user wants to holdout a validation set and find 
mean absolute deviation of the validation points from the centroid. Default value is FALSE.}

\item{train_validation_split_ratio}{Numeric. A numeric value indicating train validation split ratio. 
This argument is only used when hvt_validation has been set to TRUE. Default value for the argument is 0.8}
}
\value{
A Nested list that contains the hierarchical tessellation information. This
list has to be given as input argument to plot the tessellations.
\item{[[1]] }{A list containing information related to plotting tessellations. 
This information will include coordinates, boundaries, and other details necessary for visualizing the tessellations} 
\item{[[2]] }{A list containing information related to Sammon’s projection coordinates of the data points
in the reduced-dimensional space.}
\item{[[3]] }{A list containing detailed information about the hierarchical vector quantized data along with 
a summary section containing no of points, Quantization Error and the centroids for each cell.}
\item{[[4]] }{A list that contains all the diagnostics information of the model when diagnose is set to TRUE. 
Otherwise NA.}
\item{[[5]] }{A list that contains all the information required to generates a Mean Absolute Deviation (MAD) plot, 
if hvt_validation is set to TRUE. Otherwise NA}
\item{[[6]]}{A list containing detailed information about the hierarchical vector quantized data along with a
 summary section containing no of points, Quantization Error and the centroids for each cell which is the output of `hvq`}
\item{[[7]]}{model info: A list that contains model-generated timestamp, input parameters passed to the model 
and the validation results}
}
\description{
This is the main function to construct hierarchical voronoi tessellations.
This is done using hierarchical vector quantization(hvq). The data is represented in 2D
coordinates and the tessellations are plotted using these coordinates as
centroids. For subsequent levels, transformation is performed on the 2D
coordinates to get all the points within its parent tile. Tessellations are
plotted using these transformed points as centroids.
}
\examples{
data("EuStockMarkets")
hvt.results <- trainHVT(EuStockMarkets, n_cells = 60, depth = 1, quant.err = 0.1, 
                       distance_metric = "L1_Norm", error_metric = "max",
                       normalize = TRUE,quant_method="kmeans")
}
\seealso{
\code{\link{plotHVT}}
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>, Sangeet Moy Das <sangeet.das@mu-sigma.com>, Shantanu Vaidya <shantanu.vaidya@mu-sigma.com>
}
\keyword{Training_or_Compression}
