% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hwx.test.R
\name{hwx.test}
\alias{hwx.test}
\title{Test for HW by either full enumeration or Monte Carlo.}
\usage{
hwx.test(c, method = "auto", cutoff = 1e+07, B = 1e+05,
  statName = "LLR", histobins = 0, histobounds = c(0, 0), showCurve = T,
  safeSecs = 100, detail = 2)
}
\arguments{
\item{c}{The genotype counts. You must provide the number of each genotype. So if there are \eqn{k} alleles, you need to include the number of each of the \eqn{k(k+1)/2} genotypes. The format of \code{x} is somewhat flexible: It can be a square matrix, but only the lower-left half is used. It can be a vector of the observations in the order \eqn{a_11, a_21, a_22, a_31, ..., a_kk}. For compatability with the packages \code{genetics} and \code{adegenet}, it can also be an object of class \code{genind}, \code{genotype}, or a \code{data.frame}. If \code{c} contains multiple samples, the \code{parallel} package will be used in an attempt to employ multi-cores.}

\item{method}{Can be \dQuote{auto}, \dQuote{exact} or \dQuote{monte} to indicate the method to use. If \dQuote{auto}, the \code{hwx.test} will first check to see whether the total number of tables exceeds a cutoff specified by the parameter \code{cutoff}.}

\item{cutoff}{If \code{method} is set to \dQuote{auto}, then \code{cutoff} is used to decide whether to perform the test via the full enumeration or Monte Carlo method. If the number of tables is less than \code{cutoff}, then a full enumeration is performed. Otherwise the method will be Monte Carlo with \code{B} random trials.}

\item{B}{The number of trials to perform if Monte Carlo method is used}

\item{statName}{can be \dQuote{LLR}, \dQuote{Prob}, \dQuote{U}, or \dQuote{Chisq} depending on which one is to be ploted. Note that P values for all four are computed regardless of which one is specified with this parameter.}

\item{histobins}{If 0, no histogram is plotted. If 1 or \code{TRUE} a histogram with 500 bins is plotted. If \code{histobins} is set to a number greater than 1, a histogram with \code{histobins} bins is plotted.}

\item{histobounds}{A vector containing the left and right boundaries for the histogram's x axis. If you leave this as the default, \code{c(0,0)}, then \code{hwx.test} will compute reasonable bounds to include most of the distribution.}

\item{showCurve}{whether to show a blue curve indicating the asymptotic (chi squared) distribution. This only works for \code{LLR} and \code{Chisq}}

\item{safeSecs}{After this many seconds the calculation will be aborted. This is a safety valve to prevent attempts to compute impossibly large sets of tables.}

\item{detail}{Determines how much detail is printed. If it is set to 0, nothing is printed (useful if you use \code{hwx.test} programmatically.)}
}
\value{
Returns a list of class \code{hwtest} which includes the following items:
\item{$ Pvalues}{The four computed P values corresponding to the test statistics: \code{LLR}, \code{Prob}, \code{U} and \code{Chisq} in that order.}
\item{$ observed}{The four observed statistics in the same order as above}
\item{$ ntrials}{The number of tables examined during the calculation if done by Monte Carlo}
\item{$ tableCount}{The total number of tables if done by full enumeration}
\item{$ genotypes}{The input matrix of genotype counts}
\item{$ alleles}{The allele counts \eqn{m} corresponding to the input genotype counts}
\item{$ statName}{Which statistic to use for the histogram and in the \code{p.value} item}
\item{$ method}{Which method was used, \dQuote{exact} or \dQuote{monte}}
\item{$ detail}{An integer indicating how much detail to print. Use 0 for no printing}
\item{$ SE}{vector with the standard error for each stat. Only applicable with Monte Carlo tests}
}
\description{
The \code{hwx.test()} function is the main function of the \code{HWxtest} package. This function produces a valid test for Hardy-Weinberg frequencies for virtually any set of genotype counts. It will use either a full-enumeration method in which all possible tables with the same allele numbers are examined, or a Monte Carlo test where a large number of random tables is examined. To decide which to use, it calls \code{\link{xcountCutoff}} to determine whether the number of tables to examine is greater than \code{cutoff}. If it is, then \code{\link{mtest}} is used. Otherwise \code{\link{xtest}} is used. The result is a robust test which will always provide a meaningful and accurate P value. Each table examined is compared with the observed counts according to each of four measures of fit:  \dQuote{LLR}, \dQuote{Prob}, \dQuote{U}, or \dQuote{Chisq} corresponding to the log-likelihood ratio, the null-hypothesis probability, the U-score or the Pearson X^2 value. It can also plot a histogram showing the distribution of any of these statistics.
}
\examples{
# Data from Louis and Dempster 1987 Table 2 and Guo and Thompson 1992 Figure 2:
c <- c(0,3,1,5,18,1,3,7,5,2)
hwx.test(c)
# To see a histogram of the LLR statistic:
hwx.test(c, histobins=TRUE)
# For a histogram of the U statistic and other details of the result:
hwx.test(c, statName="U", histobins=TRUE, detail=3)

}
\references{
The methods are described by \href{http://dx.doi.org/10.1534/genetics.109.108977}{Engels, 2009. \bold{Genetics} 183:1431}.
}

